﻿using System;
using System.Text;
using System.Collections.Generic;
using Xunit;

namespace PropertySheetsTest.TestCase.Property
{
    public class PropertyNintendoSdkLibraryPath : PropertySheetsTest
    {
        protected override void InvokeAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            if (conf.ProjectType == ProjectType.Library)
            {
                return;
            }

            switch (SdkRootInfo.Environment)
            {
                case SdkEnvironment.Development:
                    InvokeDevelopmentEnvironmentAssertions(conf, ep, expander);
                    break;
                case SdkEnvironment.User:
                    InvokeUserEnvironmentAssertions(conf, ep, expander);
                    break;
                default:
                    Assert.True(false, string.Format("未知の SDK 環境です: {0}", SdkRootInfo.Environment));
                    break;
            }
        }

        private void InvokeDevelopmentEnvironmentAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            switch (conf.SubRootName)
            {
                case "Samples":
                    InvokeSamplesSubRootAssertions(conf, ep, expander);
                    break;
                case "Alice":
                case "Chris":
                case "Eris":
                case "Iris":
                case "NintendoWare":
                case "Tests":
                    // don't care. LibraryPath プロパティでチェック
                    break;
                default:
                    Assert.True(false, string.Format("未知の SubRootName です: {0}", conf.SubRootName));
                    break;
            }
        }

        protected void InvokeSamplesSubRootAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            AssertMsBuildValueEqualsPaths(
                expander,
                ep.Properties["NintendoSdkLibraryPath"],
                @"$(SdkRoot)\Programs\NintendoWare\Libraries\$(BuildTarget)\$(BuildType);"
                + @"$(SdkRoot)\Programs\Iris\Libraries\$(BuildTarget)\$(BuildType);"
                + @"$(SdkRoot)\Programs\Eris\Libraries\$(BuildTarget)\$(BuildType);"
                + @"$(SdkRoot)\Programs\Chris\Libraries\$(BuildTarget)\$(BuildType);"
                + @"$(SdkRoot)\Programs\Alice\Libraries\$(BuildTarget)\$(BuildType);"
            );
        }

        private void InvokeUserEnvironmentAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            if (conf.BuildType == "Debug")
            {
                AssertMsBuildValueEqualsPaths(
                    expander,
                    ep.Properties["NintendoSdkLibraryPath"],
                    @"$(SdkRoot)\Libraries\$(BuildTarget)\Debug;"
                    + @"$(SdkRoot)\Libraries\$(BuildTarget)\Develop;"
                );
            }
            else
            {
                AssertMsBuildValueEqualsPaths(
                    expander,
                    ep.Properties["NintendoSdkLibraryPath"],
                    @"$(SdkRoot)\Libraries\$(BuildTarget)\$(BuildType);"
                );
            }
        }
    }
}
