﻿using System;
using System.Text;
using System.Collections.Generic;
using Xunit;

namespace PropertySheetsTest.TestCase.Property
{
    public class PropertyNintendoSdkLibSuffix : PropertySheetsTest
    {
        protected override void InvokeAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            switch (conf.Platform)
            {
                case "Win32":
                case "x64":
                    Assert.Equal(".lib", ep.Properties["NintendoSdkLibSuffix"]);
                    break;
                case "NX32":
                case "NX64":
                    Assert.Equal(".a", ep.Properties["NintendoSdkLibSuffix"]);
                    break;
                default:
                    Assert.True(false, string.Format($"未知の Platform です: {conf.Platform}"));
                    break;
            }
        }
    }
}
