﻿using System;
using System.Text;
using System.Collections.Generic;
using Xunit;

namespace PropertySheetsTest.TestCase.Property
{
    public class PropertyNintendoSdkIncludePath : PropertySheetsTest
    {
        protected override void InvokeAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            switch (SdkRootInfo.Environment)
            {
                case SdkEnvironment.Development:
                    InvokeDevelopmentEnvironmentAssertions(conf, ep, expander);
                    break;
                case SdkEnvironment.User:
                    InvokeUserEnvironmentAssertions(conf, ep, expander);
                    break;
                default:
                    Assert.True(false, string.Format("未知の SDK 環境です: {0}", SdkRootInfo.Environment));
                    break;
            }
        }

        private void InvokeDevelopmentEnvironmentAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            switch (conf.SubRootName)
            {
                case "Samples":
                    InvokeSamplesSubRootAssertions(conf, ep, expander);
                    break;
                case "Alice":
                case "Chris":
                case "Eris":
                case "Iris":
                case "NintendoWare":
                case "Tests":
                    // don't care. IncludePath プロパティでチェック
                    break;
                default:
                    Assert.True(false, string.Format("未知の SubRootName です: {0}", conf.SubRootName));
                    break;
            }
        }

        protected void InvokeSamplesSubRootAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            switch (conf.Platform)
            {
                case "Win32":
                case "x64":
                    switch (conf.ProjectType)
                    {
                        case ProjectType.Library:
                            AssertMsBuildValueEqualsPaths(
                                expander,
                                ep.Properties["NintendoSdkIncludePath"],
                                @"$(SdkRoot)\Programs\NintendoWare\Include;"
                                + @"$(SdkRoot)\Programs\NintendoWare\Outputs\Include;"
                                + @"$(SdkRoot)\Programs\Iris\Include;"
                                + @"$(SdkRoot)\Programs\Iris\Outputs\Include;"
                                + @"$(SdkRoot)\Programs\Eris\Include;"
                                + @"$(SdkRoot)\Programs\Eris\Outputs\Include;"
                                + @"$(SdkRoot)\Programs\Chris\Include;"
                                + @"$(SdkRoot)\Programs\Chris\Outputs\Include;"
                                + @"$(SdkRoot)\Programs\Alice\Include;"
                                + @"$(SdkRoot)\Programs\Alice\Outputs\Include;"
                                + @"$(SdkRoot)\Common\Configs\Targets\$(BuildTarget)\Include;"
                            );
                            break;
                        case ProjectType.Program:
                            AssertMsBuildValueEqualsPaths(
                                expander,
                                ep.Properties["NintendoSdkIncludePath"],
                                @"$(SdkRoot)\Programs\NintendoWare\Include;"
                                + @"$(SdkRoot)\Programs\NintendoWare\Outputs\Include;"
                                + @"$(SdkRoot)\Programs\Iris\Include;"
                                + @"$(SdkRoot)\Programs\Iris\Outputs\Include;"
                                + @"$(SdkRoot)\Programs\Eris\Include;"
                                + @"$(SdkRoot)\Programs\Eris\Outputs\Include;"
                                + @"$(SdkRoot)\Programs\Chris\Include;"
                                + @"$(SdkRoot)\Programs\Chris\Outputs\Include;"
                                + @"$(SdkRoot)\Programs\Alice\Include;"
                                + @"$(SdkRoot)\Programs\Alice\Outputs\Include;"
                                + @"$(SdkRoot)\Common\Configs\Targets\$(BuildTarget)\Include;"
                            );
                            break;
                        default:
                            Assert.True(false, string.Format($"未知の ProjectType です: {conf.ProjectType}"));
                            break;
                    }
                    break;
                case "NX32":
                case "NX64":
                    AssertMsBuildValueEqualsPaths(
                        expander,
                        ep.Properties["NintendoSdkIncludePath"],
                        @"$(SdkRoot)\Programs\NintendoWare\Include;"
                        + @"$(SdkRoot)\Programs\NintendoWare\Outputs\Include;"
                        + @"$(SdkRoot)\Programs\Iris\Include;"
                        + @"$(SdkRoot)\Programs\Iris\Outputs\Include;"
                        + @"$(SdkRoot)\Programs\Eris\Include;"
                        + @"$(SdkRoot)\Programs\Eris\Outputs\Include;"
                        + @"$(SdkRoot)\Programs\Chris\Include;"
                        + @"$(SdkRoot)\Programs\Chris\Outputs\Include;"
                        + @"$(SdkRoot)\Programs\Alice\Include;"
                        + @"$(SdkRoot)\Programs\Alice\Outputs\Include;"
                        + @"$(SdkRoot)\Common\Configs\Targets\$(BuildTarget)\Include;"
                    );
                    break;
                default:
                    Assert.True(false, string.Format($"未知の Platform です: {conf.Platform}"));
                    break;
            }
        }

        private void InvokeUserEnvironmentAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            AssertMsBuildValueEqualsPaths(
                expander,
                ep.Properties["NintendoSdkIncludePath"],
                @"$(SdkRoot)\Include;"
                + @"$(SdkRoot)\Common\Configs\Targets\$(BuildTarget)\Include;"
            );
        }
    }
}
