﻿using System;
using System.Text;
using System.Collections.Generic;
using Xunit;

namespace PropertySheetsTest.TestCase.Property
{
    public class PropertyMainRuntimeObjectName : PropertySheetsTest
    {
        protected override void InvokeAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            if (!conf.IsNXPlatform)
            {
                return;
            }

            switch (conf.ProjectType)
            {
                case ProjectType.Library:
                case ProjectType.DynamicLibrary:
                    // don't care
                    break;
                case ProjectType.Program:
                    Assert.Equal("nnApplication.o", ep.Properties["MainRuntimeObjectName"]);
                    break;
                case ProjectType.ProgramWithoutSdkNso:
                    Assert.Equal("nnApplicationWithoutSdkNso.o", ep.Properties["MainRuntimeObjectName"]);
                    break;
                case ProjectType.SystemProgram:
                    Assert.Equal("nnSystemProgram.o", ep.Properties["MainRuntimeObjectName"]);
                    break;
                default:
                    Assert.True(false, string.Format($"未知の ProjectType です: {conf.ProjectType}"));
                    break;
            }
        }
    }
}
