﻿using System;
using System.Text;
using System.Collections.Generic;
using Xunit;

namespace PropertySheetsTest.TestCase.Property
{
    public class PropertyLibraryPath : PropertySheetsTest
    {
        protected override void InvokeAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            switch (SdkRootInfo.Environment)
            {
                case SdkEnvironment.Development:
                    switch (conf.SubRootName)
                    {
                        case "Alice":
                            InvokeAliceSubRootAssertions(conf, ep, expander);
                            break;
                        case "Chris":
                            InvokeChrisSubRootAssertions(conf, ep, expander);
                            break;
                        case "Eris":
                            InvokeErisSubRootAssertions(conf, ep, expander);
                            break;
                        case "Iris":
                            InvokeIrisSubRootAssertions(conf, ep, expander);
                            break;
                        case "NintendoWare":
                            InvokeNintendoWareSubRootAssertions(conf, ep, expander);
                            break;
                        case "Samples":
                            InvokeSamplesSubRootAssertions(conf, ep, expander);
                            break;
                        case "Tests":
                            InvokeTestsSubRootAssertions(conf, ep, expander);
                            break;
                        default:
                            Assert.True(false, string.Format("未知の SubRootName です: {0}", conf.SubRootName));
                            break;
                    }
                    break;
                case SdkEnvironment.User:
                    InvokeUserEnvironmentAssertions(conf, ep, expander);
                    break;
                default:
                    Assert.True(false, string.Format("未知の SDK 環境です: {0}", SdkRootInfo.Environment));
                    break;
            }
        }

        private void InvokeAliceSubRootAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            AssertMsBuildValueContainsPathsInOrder(
                expander,
                ep.Properties["LibraryPath"],
                @"$(SdkRoot)\Programs\Alice\Libraries\$(BuildTarget)\$(BuildType);"
            );
        }

        private void InvokeChrisSubRootAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            AssertMsBuildValueContainsPathsInOrder(
                expander,
                ep.Properties["LibraryPath"],
                @"$(SdkRoot)\Programs\Chris\Libraries\$(BuildTarget)\$(BuildType);"
                + @"$(SdkRoot)\Programs\Alice\Libraries\$(BuildTarget)\$(BuildType);"
            );
        }

        private void InvokeErisSubRootAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            AssertMsBuildValueContainsPathsInOrder(
                expander,
                ep.Properties["LibraryPath"],
                @"$(SdkRoot)\Programs\Eris\Libraries\$(BuildTarget)\$(BuildType);"
                + @"$(SdkRoot)\Programs\Chris\Libraries\$(BuildTarget)\$(BuildType);"
                + @"$(SdkRoot)\Programs\Alice\Libraries\$(BuildTarget)\$(BuildType);"
            );
        }

        private void InvokeIrisSubRootAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            AssertMsBuildValueContainsPathsInOrder(
                expander,
                ep.Properties["LibraryPath"],
                @"$(SdkRoot)\Programs\Iris\Libraries\$(BuildTarget)\$(BuildType);"
                + @"$(SdkRoot)\Programs\Eris\Libraries\$(BuildTarget)\$(BuildType);"
                + @"$(SdkRoot)\Programs\Chris\Libraries\$(BuildTarget)\$(BuildType);"
                + @"$(SdkRoot)\Programs\Alice\Libraries\$(BuildTarget)\$(BuildType);"
            );
        }

        private void InvokeNintendoWareSubRootAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            AssertMsBuildValueContainsPathsInOrder(
                expander,
                ep.Properties["LibraryPath"],
                @"$(SdkRoot)\Programs\NintendoWare\Libraries\$(BuildTarget)\$(BuildType);"
                + @"$(SdkRoot)\Programs\Iris\Libraries\$(BuildTarget)\$(BuildType);"
                + @"$(SdkRoot)\Programs\Eris\Libraries\$(BuildTarget)\$(BuildType);"
                + @"$(SdkRoot)\Programs\Chris\Libraries\$(BuildTarget)\$(BuildType);"
                + @"$(SdkRoot)\Programs\Alice\Libraries\$(BuildTarget)\$(BuildType);"
            );
        }

        private void InvokeSamplesSubRootAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            AssertMsBuildValueContainsPathsInOrder(
                expander,
                ep.Properties["LibraryPath"],
                @"$(SdkRoot)\Samples\Libraries\$(BuildTarget)\$(BuildType);"
                + @"$(SdkRoot)\Programs\NintendoWare\Libraries\$(BuildTarget)\$(BuildType);"
                + @"$(SdkRoot)\Programs\Iris\Libraries\$(BuildTarget)\$(BuildType);"
                + @"$(SdkRoot)\Programs\Eris\Libraries\$(BuildTarget)\$(BuildType);"
                + @"$(SdkRoot)\Programs\Chris\Libraries\$(BuildTarget)\$(BuildType);"
                + @"$(SdkRoot)\Programs\Alice\Libraries\$(BuildTarget)\$(BuildType);"
            );
        }

        private void InvokeTestsSubRootAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            AssertMsBuildValueContainsPathsInOrder(
                expander,
                ep.Properties["LibraryPath"],
                @"$(SdkRoot)\Tests\Libraries\$(BuildTarget)\$(BuildType);"
                + @"$(SdkRoot)\Programs\NintendoWare\Libraries\$(BuildTarget)\$(BuildType);"
                + @"$(SdkRoot)\Programs\Iris\Libraries\$(BuildTarget)\$(BuildType);"
                + @"$(SdkRoot)\Programs\Eris\Libraries\$(BuildTarget)\$(BuildType);"
                + @"$(SdkRoot)\Programs\Chris\Libraries\$(BuildTarget)\$(BuildType);"
                + @"$(SdkRoot)\Programs\Alice\Libraries\$(BuildTarget)\$(BuildType);"
            );
        }

        private void InvokeUserEnvironmentAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            if (conf.BuildType == "Debug")
            {
                AssertMsBuildValueContainsPathsInOrder(
                    expander,
                    ep.Properties["LibraryPath"],
                    @"$(SdkRoot)\Libraries\$(BuildTarget)\Debug;"
                    + @"$(SdkRoot)\Libraries\$(BuildTarget)\Develop;"
                );
            }
            else
            {
                AssertMsBuildValueContainsPathsInOrder(
                    expander,
                    ep.Properties["LibraryPath"],
                    @"$(SdkRoot)\Libraries\$(BuildTarget)\$(BuildType);"
                );
            }
        }
    }
}
