﻿using System;
using System.Text;
using System.Collections.Generic;
using Xunit;

namespace PropertySheetsTest.TestCase.Property
{
    public class PropertyIncludePath : PropertySheetsTest
    {
        protected override void InvokeAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            switch (conf.SubRootName)
            {
                case "Alice":
                    InvokeAliceSubRootAssertions(conf, ep, expander);
                    break;
                case "Chris":
                    InvokeChrisSubRootAssertions(conf, ep, expander);
                    break;
                case "Eris":
                    InvokeErisSubRootAssertions(conf, ep, expander);
                    break;
                case "Iris":
                    InvokeIrisSubRootAssertions(conf, ep, expander);
                    break;
                case "NintendoWare":
                    InvokeNintendoWareSubRootAssertions(conf, ep, expander);
                    break;
                case "Samples":
                    InvokeSamplesSubRootAssertions(conf, ep, expander);
                    break;
                case "Tests":
                    InvokeTestsSubRootAssertions(conf, ep, expander);
                    break;
                case "Users":
                    InvokeUserEnvironmentAssertions(conf, ep, expander);
                    break;
                default:
                    Assert.True(false, string.Format("未知の SubRootName です: {0}", conf.SubRootName));
                    break;
            }
        }

        private void InvokeAliceSubRootAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            AssertMsBuildValueContainsPathsInOrder(
                expander,
                ep.Properties["IncludePath"],
                @"$(SdkRoot)\Programs\Alice\Include;"
                + @"$(SdkRoot)\Programs\Alice\Outputs\Include;"
                + @"$(SdkRoot)\Common\Configs\Targets\$(BuildTarget)\Include;"
            );
        }

        private void InvokeChrisSubRootAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            AssertMsBuildValueContainsPathsInOrder(
                expander,
                ep.Properties["IncludePath"],
                @"$(SdkRoot)\Programs\Chris\Include;"
                + @"$(SdkRoot)\Programs\Chris\Outputs\Include;"
                + @"$(SdkRoot)\Programs\Alice\Include;"
                + @"$(SdkRoot)\Programs\Alice\Outputs\Include;"
                + @"$(SdkRoot)\Common\Configs\Targets\$(BuildTarget)\Include;"
            );
        }

        private void InvokeErisSubRootAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            AssertMsBuildValueContainsPathsInOrder(
                expander,
                ep.Properties["IncludePath"],
                @"$(SdkRoot)\Programs\Eris\Include;"
                + @"$(SdkRoot)\Programs\Eris\Outputs\Include;"
                + @"$(SdkRoot)\Programs\Chris\Include;"
                + @"$(SdkRoot)\Programs\Chris\Outputs\Include;"
                + @"$(SdkRoot)\Programs\Alice\Include;"
                + @"$(SdkRoot)\Programs\Alice\Outputs\Include;"
                + @"$(SdkRoot)\Common\Configs\Targets\$(BuildTarget)\Include;"
            );
        }

        private void InvokeIrisSubRootAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            switch (SdkRootInfo.Environment)
            {
                case SdkEnvironment.Development:
                    AssertMsBuildValueContainsPathsInOrder(
                        expander,
                        ep.Properties["IncludePath"],
                        @"$(SdkRoot)\Programs\Iris\Include;"
                        + @"$(SdkRoot)\Programs\Iris\Outputs\Include;"
                        + @"$(SdkRoot)\Programs\Eris\Include;"
                        + @"$(SdkRoot)\Programs\Eris\Outputs\Include;"
                        + @"$(SdkRoot)\Programs\Chris\Include;"
                        + @"$(SdkRoot)\Programs\Chris\Outputs\Include;"
                        + @"$(SdkRoot)\Programs\Alice\Include;"
                        + @"$(SdkRoot)\Programs\Alice\Outputs\Include;"
                        + @"$(SdkRoot)\Common\Configs\Targets\$(BuildTarget)\Include;"
                    );
                    break;
                case SdkEnvironment.User:
                    InvokeUserEnvironmentAssertions(conf, ep, expander);
                    break;
                default:
                    Assert.True(false, string.Format("未知の SdkEnvironment です: {0}", SdkRootInfo.Environment));
                    break;
            }
        }

        private void InvokeNintendoWareSubRootAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            switch (SdkRootInfo.Environment)
            {
                case SdkEnvironment.Development:
                    AssertMsBuildValueContainsPathsInOrder(
                        expander,
                        ep.Properties["IncludePath"],
                        @"$(SdkRoot)\Programs\NintendoWare\Include;"
                        + @"$(SdkRoot)\Programs\NintendoWare\Outputs\Include;"
                        + @"$(SdkRoot)\Programs\Iris\Include;"
                        + @"$(SdkRoot)\Programs\Iris\Outputs\Include;"
                        + @"$(SdkRoot)\Programs\Eris\Include;"
                        + @"$(SdkRoot)\Programs\Eris\Outputs\Include;"
                        + @"$(SdkRoot)\Programs\Chris\Include;"
                        + @"$(SdkRoot)\Programs\Chris\Outputs\Include;"
                        + @"$(SdkRoot)\Programs\Alice\Include;"
                        + @"$(SdkRoot)\Programs\Alice\Outputs\Include;"
                        + @"$(SdkRoot)\Common\Configs\Targets\$(BuildTarget)\Include;"
                    );
                    break;
                case SdkEnvironment.User:
                    InvokeUserEnvironmentAssertions(conf, ep, expander);
                    break;
                default:
                    Assert.True(false, string.Format("未知の SdkEnvironment です: {0}", SdkRootInfo.Environment));
                    break;
            }
        }

        private void InvokeSamplesSubRootAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            switch (SdkRootInfo.Environment)
            {
                case SdkEnvironment.Development:
                    AssertMsBuildValueContainsPathsInOrder(
                        expander,
                        ep.Properties["IncludePath"],
                        @"$(SdkRoot)\Samples\Include;"
                        + @"$(SdkRoot)\Samples\Outputs\Include;"
                        + @"$(SdkRoot)\Programs\NintendoWare\Include;"
                        + @"$(SdkRoot)\Programs\NintendoWare\Outputs\Include;"
                        + @"$(SdkRoot)\Programs\Iris\Include;"
                        + @"$(SdkRoot)\Programs\Iris\Outputs\Include;"
                        + @"$(SdkRoot)\Programs\Eris\Include;"
                        + @"$(SdkRoot)\Programs\Eris\Outputs\Include;"
                        + @"$(SdkRoot)\Programs\Chris\Include;"
                        + @"$(SdkRoot)\Programs\Chris\Outputs\Include;"
                        + @"$(SdkRoot)\Programs\Alice\Include;"
                        + @"$(SdkRoot)\Programs\Alice\Outputs\Include;"
                        + @"$(SdkRoot)\Common\Configs\Targets\$(BuildTarget)\Include;"
                    );
                    break;
                case SdkEnvironment.User:
                    AssertMsBuildValueContainsPathsInOrder(
                        expander,
                        ep.Properties["IncludePath"],
                        @"$(SdkRoot)\Samples\Include;"
                        + @"$(SdkRoot)\Samples\Outputs\Include;"
                        + @"$(SdkRoot)\Include;"
                        + @"$(SdkRoot)\Common\Configs\Targets\$(BuildTarget)\Include;"
                    );
                    break;
                default:
                    Assert.True(false, string.Format("未知の SdkEnvironment です: {0}", SdkRootInfo.Environment));
                    break;
            }
        }

        private void InvokeTestsSubRootAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            AssertMsBuildValueContainsPathsInOrder(
                expander,
                ep.Properties["IncludePath"],
                ((conf.Platform == "Win32" || conf.Platform == "x64")
                    ? @"$(SdkRoot)\Externals\googletest\googlemock\include;"
                    + @"$(SdkRoot)\Externals\googletest\googletest\include;"
                    : @"")
                + @"$(SdkRoot)\Tests\Include;"
                + @"$(SdkRoot)\Tests\Outputs\Include;"
                + @"$(SdkRoot)\Programs\NintendoWare\Include;"
                + @"$(SdkRoot)\Programs\NintendoWare\Outputs\Include;"
                + @"$(SdkRoot)\Programs\Iris\Include;"
                + @"$(SdkRoot)\Programs\Iris\Outputs\Include;"
                + @"$(SdkRoot)\Programs\Eris\Include;"
                + @"$(SdkRoot)\Programs\Eris\Outputs\Include;"
                + @"$(SdkRoot)\Programs\Chris\Include;"
                + @"$(SdkRoot)\Programs\Chris\Outputs\Include;"
                + @"$(SdkRoot)\Programs\Alice\Include;"
                + @"$(SdkRoot)\Programs\Alice\Outputs\Include;"
                + @"$(SdkRoot)\Common\Configs\Targets\$(BuildTarget)\Include;"
            );
        }

        private void InvokeUserEnvironmentAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            AssertMsBuildValueContainsPathsInOrder(
                expander,
                ep.Properties["IncludePath"],
                @"$(SdkRoot)\Include;"
                + @"$(SdkRoot)\Common\Configs\Targets\$(BuildTarget)\Include;"
            );
        }
    }
}
