﻿using System;
using System.Text;
using System.Collections.Generic;
using Xunit;

namespace PropertySheetsTest.TestCase.Property
{
    public class PropertyConfigurationType : PropertySheetsTest
    {
        protected override void InvokeAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            switch (conf.ProjectType)
            {
                case ProjectType.Library:
                    Assert.Equal("StaticLibrary", ep.Properties["ConfigurationType"]);
                    break;
                case ProjectType.DynamicLibrary:
                    Assert.Equal("DynamicLibrary", ep.Properties["ConfigurationType"]);
                    break;
                case ProjectType.Program:
                case ProjectType.ProgramWithoutSdkNso:
                case ProjectType.SystemProgram:
                    Assert.Equal("Application", ep.Properties["ConfigurationType"]);
                    break;
                default:
                    Assert.True(false, string.Format("未知の ProjectType です: {0}", conf.ProjectType));
                    break;
            }
        }
    }
}
