﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Xunit;

namespace PropertySheetsTest.TestCase.ItemMetadata
{
    public class LinkUseUnifiedCommandLineGenerator : PropertySheetsTest
    {
        protected override void InvokeAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            if (!conf.IsNXPlatform)
            {
                return;
            }

            if (SdkRootInfo.Environment == SdkEnvironment.User && conf.ProjectType == ProjectType.SystemProgram)
            {
                Assert.Equal("false", ep.Metadata["Link.UseUnifiedLinkCommandLineGenerator"]);
            }
            else
            {
                Assert.Equal("true", ep.Metadata["Link.UseUnifiedLinkCommandLineGenerator"]);
            }
        }
    }
}
