﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Xunit;

namespace PropertySheetsTest.TestCase.ItemMetadata
{
    public class LinkSdkRuntimeDependencies : PropertySheetsTest
    {
        protected override void InvokeAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            if (!conf.IsNXPlatform)
            {
                return;
            }

            switch (conf.ProjectType)
            {
                case ProjectType.Library:
                    // don't care
                    break;
                case ProjectType.DynamicLibrary:
                    AssertUtil.AssertOrderedSequenceEqual(
                        Util.SplitMsBuildValue(ep.Metadata["Link.SdkRuntimeDependencies"]),
                        new[] { "rocrt_nro.o" });
                    break;
                case ProjectType.Program:
                    AssertUtil.AssertOrderedSequenceEqual(
                        Util.SplitMsBuildValue(ep.Metadata["Link.SdkRuntimeDependencies"]),
                        new[] { "rocrt.o", "nnApplication.o" });
                    break;
                case ProjectType.ProgramWithoutSdkNso:
                    AssertUtil.AssertOrderedSequenceEqual(
                        Util.SplitMsBuildValue(ep.Metadata["Link.SdkRuntimeDependencies"]),
                        new[] { "rocrt.o", "nnApplicationWithoutSdkNso.o" });
                    break;
                case ProjectType.SystemProgram:
                    AssertUtil.AssertOrderedSequenceEqual(
                        Util.SplitMsBuildValue(ep.Metadata["Link.SdkRuntimeDependencies"]),
                        new[] { "rocrt.o", "nnrtld.o", "nnSystemProgram.o" });
                    break;
                default:
                    Assert.True(false, string.Format($"未知の ProjectType です: {conf.ProjectType}"));
                    break;
            }
        }
    }
}
