﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Xunit;

namespace PropertySheetsTest.TestCase.ItemMetadata
{
    public class LinkProcessType : PropertySheetsTest
    {
        protected override void InvokeAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            if (!conf.IsNXPlatform)
            {
                return;
            }
            if (ep.Properties["NintendoSdkUseUnifiedLinkCommandLineGenerator"] != "true")
            {
                return;
            }

            switch (conf.ProjectType)
            {
                case ProjectType.Library:
                case ProjectType.DynamicLibrary:
                    // don't care
                    break;
                case ProjectType.Program:
                    Assert.Equal("Application", ep.Metadata["Link.ProcessType"]);
                    break;
                case ProjectType.ProgramWithoutSdkNso:
                    Assert.Equal("ApplicationWithoutSdkNso", ep.Metadata["Link.ProcessType"]);
                    break;
                case ProjectType.SystemProgram:
                    Assert.Equal("SystemProgram", ep.Metadata["Link.ProcessType"]);
                    break;
                default:
                    Assert.True(false, string.Format($"未知の ProjectType です: {conf.ProjectType}"));
                    break;
            }
        }
    }
}
