﻿using System;
using System.Text;
using System.Collections.Generic;
using Xunit;

namespace PropertySheetsTest.TestCase.ItemMetadata
{
    public class LinkLinkerScript : PropertySheetsTest
    {
        protected override void InvokeAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            if (!conf.IsNXPlatform)
            {
                return;
            }
            if (conf.ProjectType == ProjectType.Library)
            {
                return;
            }

            switch (conf.SubRootName)
            {
                case "Alice":
                case "Chris":
                case "Eris":
                    // don't care
                    break;
                case "Iris":
                case "NintendoWare":
                case "Tests":
                case "Samples":
                    switch (SdkRootInfo.Environment)
                    {
                        case SdkEnvironment.Development:
                            InvokeDevelopmentEnvironmentAssertions(conf, ep, expander);
                            break;
                        case SdkEnvironment.User:
                            InvokeUserEnvironmentAssertions(conf, ep, expander);
                            break;
                        default:
                            Assert.True(false, string.Format("未知の SdkEnvironment です: {0}", SdkRootInfo.Environment));
                            break;
                    }
                    break;
                case "Users":
                    InvokeUserEnvironmentAssertions(conf, ep, expander);
                    break;
                default:
                    Assert.True(false, string.Format("未知の SubRootName です: {0}", conf.SubRootName));
                    break;
            }
        }

        private void InvokeDevelopmentEnvironmentAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            switch (conf.Platform)
            {
                case "NX32":
                    switch (conf.ProjectType)
                    {
                        case ProjectType.Library:
                            // don't care
                            break;
                        case ProjectType.DynamicLibrary:
                            AssertMsBuildValueEqualsPaths(expander,
                                ep.Metadata["Link.LinkerScript"],
                                @"$(SdkRoot)\Programs\Iris\Resources\SpecFiles\RoModule.arm.ilp32.ldscript");
                            break;
                        case ProjectType.Program:
                        case ProjectType.ProgramWithoutSdkNso:
                            AssertMsBuildValueEqualsPaths(expander,
                                ep.Metadata["Link.LinkerScript"],
                                @"$(SdkRoot)\Programs\Iris\Resources\SpecFiles\Application.arm.ilp32.ldscript");
                            break;
                        case ProjectType.SystemProgram:
                            AssertMsBuildValueEqualsPaths(expander,
                                ep.Metadata["Link.LinkerScript"],
                                @"$(SdkRoot)\Programs\Iris\Resources\SpecFiles\SystemProgram.arm.ilp32.ldscript");
                            break;
                        default:
                            Assert.True(false, string.Format($"未知の ProjectType です: {conf.ProjectType}"));
                            break;
                    }
                    break;
                case "NX64":
                    switch (conf.ProjectType)
                    {
                        case ProjectType.Library:
                            // don't care
                            break;
                        case ProjectType.DynamicLibrary:
                            AssertMsBuildValueEqualsPaths(expander,
                                ep.Metadata["Link.LinkerScript"],
                                @"$(SdkRoot)\Programs\Iris\Resources\SpecFiles\RoModule.aarch64.lp64.ldscript");
                            break;
                        case ProjectType.Program:
                        case ProjectType.ProgramWithoutSdkNso:
                            AssertMsBuildValueEqualsPaths(expander,
                                ep.Metadata["Link.LinkerScript"],
                                @"$(SdkRoot)\Programs\Iris\Resources\SpecFiles\Application.aarch64.lp64.ldscript");
                            break;
                        case ProjectType.SystemProgram:
                            AssertMsBuildValueEqualsPaths(expander,
                                ep.Metadata["Link.LinkerScript"],
                                @"$(SdkRoot)\Programs\Iris\Resources\SpecFiles\SystemProgram.aarch64.lp64.ldscript");
                            break;
                        default:
                            Assert.True(false, string.Format($"未知の ProjectType です: {conf.ProjectType}"));
                            break;
                    }
                    break;
                default:
                    Assert.True(false, string.Format("Platform が NX32 でも NX64 でもありません: {0}", conf.Platform));
                    break;
            }
        }

        private void InvokeUserEnvironmentAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            switch (conf.Platform)
            {
                case "NX32":
                    switch (conf.ProjectType)
                    {
                        case ProjectType.Library:
                            // don't care
                            break;
                        case ProjectType.DynamicLibrary:
                            AssertMsBuildValueEqualsPaths(expander,
                                ep.Metadata["Link.LinkerScript"],
                                @"$(SdkRoot)\Resources\SpecFiles\RoModule.arm.ilp32.ldscript");
                            break;
                        case ProjectType.Program:
                        case ProjectType.ProgramWithoutSdkNso:
                            AssertMsBuildValueEqualsPaths(expander,
                                ep.Metadata["Link.LinkerScript"],
                                @"$(SdkRoot)\Resources\SpecFiles\Application.arm.ilp32.ldscript");
                            break;
                        case ProjectType.SystemProgram:
                            AssertMsBuildValueEqualsPaths(expander,
                                ep.Metadata["Link.LinkerScript"],
                                @"$(SdkRoot)\Resources\SpecFiles\SystemProgram.arm.ilp32.ldscript");
                            break;
                        default:
                            Assert.True(false, string.Format($"未知の ProjectType です: {conf.ProjectType}"));
                            break;
                    }
                    break;
                case "NX64":
                    switch (conf.ProjectType)
                    {
                        case ProjectType.Library:
                            // don't care
                            break;
                        case ProjectType.DynamicLibrary:
                            AssertMsBuildValueEqualsPaths(expander,
                                ep.Metadata["Link.LinkerScript"],
                                @"$(SdkRoot)\Resources\SpecFiles\RoModule.aarch64.lp64.ldscript");
                            break;
                        case ProjectType.Program:
                        case ProjectType.ProgramWithoutSdkNso:
                            AssertMsBuildValueEqualsPaths(expander,
                                ep.Metadata["Link.LinkerScript"],
                                @"$(SdkRoot)\Resources\SpecFiles\Application.aarch64.lp64.ldscript");
                            break;
                        case ProjectType.SystemProgram:
                            AssertMsBuildValueEqualsPaths(expander,
                                ep.Metadata["Link.LinkerScript"],
                                @"$(SdkRoot)\Resources\SpecFiles\SystemProgram.aarch64.lp64.ldscript");
                            break;
                        default:
                            Assert.True(false, string.Format($"未知の ProjectType です: {conf.ProjectType}"));
                            break;
                    }
                    break;
                default:
                    Assert.True(false, string.Format("Platform が NX32 でも NX64 でもありません: {0}", conf.Platform));
                    break;
            }
        }
    }
}
