﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Xunit;

namespace PropertySheetsTest.TestCase.ItemMetadata
{
    public class LinkAuthoringUserCommand : PropertySheetsTest
    {
        protected override void InvokeAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            if (!conf.IsNXPlatform)
            {
                return;
            }

            switch (conf.ProjectType)
            {
                case ProjectType.Library:
                case ProjectType.DynamicLibrary:
                case ProjectType.Program:
                case ProjectType.ProgramWithoutSdkNso:
                    // don't care
                    break;
                case ProjectType.SystemProgram:
                    switch (SdkRootInfo.Environment)
                    {
                        case SdkEnvironment.Development:
                            // TORIAEZU: システムプロセスをビルドすると仮定する
                            AssertUtil.AssertSequenceContainsElementsInOrder(
                                Util.TokenizeCommandLineOptions(ep.Metadata["Link.AuthoringUserCommand"]),
                                new[] {"--keyconfig", expander.Expand(@"$(SdkRoot)\Tools\CommandLineTools\AuthoringTool\AuthoringTool.repository.keyconfig.xml"), "--keyindex", "2" });
                            break;
                        case SdkEnvironment.User:
                            // TORIAEZU: Ocean をビルドすると仮定する
                            AssertUtil.AssertSequenceContainsElementsInOrder(
                                Util.TokenizeCommandLineOptions(ep.Metadata["Link.AuthoringUserCommand"]),
                                new[] { "--keyconfig", expander.Expand(@"$(SdkRoot)\Tools\CommandLineTools\AuthoringTool\AuthoringTool.ocean.keyconfig.xml") });
                            break;
                        default:
                            Assert.True(false, string.Format("未知の SdkEnvironment です: {0}", SdkRootInfo.Environment));
                            break;
                    }
                    break;
                default:
                    Assert.True(false, string.Format($"未知の ProjectType です: {conf.ProjectType}"));
                    break;
            }
        }
    }
}
