﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Xunit;

namespace PropertySheetsTest.TestCase.ItemMetadata
{
    public class LinkAdditionalSearchDependencies : PropertySheetsTest
    {
        protected override void InvokeAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            if (!conf.IsNXPlatform)
            {
                return;
            }

            switch (conf.ProjectType)
            {
                case ProjectType.Library:
                    // don't care
                    break;
                case ProjectType.DynamicLibrary:
                case ProjectType.Program:
                    AssertUtil.AssertSequenceEqual(
                        Util.SplitMsBuildValue(ep.Metadata["Link.AdditionalSearchDependencies"]),
                        Enumerable.Empty<string>());
                    break;
                case ProjectType.ProgramWithoutSdkNso:
                case ProjectType.SystemProgram:
                    AssertUtil.AssertOrderedSequenceEqual(
                        Util.SplitMsBuildValue(ep.Metadata["Link.AdditionalSearchDependencies"]),
                        new[] { "c", "c++", "c++abi", "compiler_rt", "shim", "unwind" });
                    break;
                default:
                    Assert.True(false, string.Format($"未知の ProjectType です: {conf.ProjectType}"));
                    break;
            }
        }
    }
}
