﻿using System;
using System.Text;
using System.Collections.Generic;
using Xunit;

namespace PropertySheetsTest.TestCase.ItemMetadata
{
    public class ClCompileRuntimeTypeInfo : PropertySheetsTest
    {
        protected override void InvokeAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            if (!conf.IsNXPlatform)
            {
                return;
            }

            switch (conf.SubRootName)
            {
                case "Alice":
                case "Chris":
                case "Eris":
                case "Iris":
                case "NintendoWare":
                case "Samples":
                case "Tests":
                    Assert.Equal("true", ep.Metadata["ClCompile.RuntimeTypeInfo"]);
                    break;
                case "Users":
                    Assert.Equal("false", ep.Metadata["ClCompile.RuntimeTypeInfo"]);
                    break;
                default:
                    Assert.True(false, string.Format("未知の SubRootName です: {0}", conf.SubRootName));
                    break;
            }
        }
    }
}
