﻿using System;
using System.Text;
using System.Collections.Generic;
using Xunit;

namespace PropertySheetsTest.TestCase.ItemMetadata
{
    public class ClCompileRuntimeLibrary : PropertySheetsTest
    {
        protected override void InvokeAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            if (!conf.IsWinPlatform)
            {
                return;
            }

            switch (conf.BuildType)
            {
                case "Debug":
                    Assert.Equal("MultiThreadedDebugDLL", ep.Metadata["ClCompile.RuntimeLibrary"]);
                    break;
                case "Develop":
                    Assert.Equal("MultiThreadedDLL", ep.Metadata["ClCompile.RuntimeLibrary"]);
                    break;
                case "Release":
                    Assert.Equal("MultiThreadedDLL", ep.Metadata["ClCompile.RuntimeLibrary"]);
                    break;
                default:
                    Assert.True(false, string.Format("未知の BuildType です: {0}", conf.BuildType));
                    break;
            }
        }
    }
}
