﻿using System;
using System.Text;
using System.Collections.Generic;
using Xunit;

namespace PropertySheetsTest.TestCase.ItemMetadata
{
    public class ClCompileNoBuiltIn : PropertySheetsTest
    {
        protected override void InvokeAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            if (!conf.IsNXPlatform)
            {
                return;
            }

            switch (conf.BuildType)
            {
                case "Debug":
                    Assert.Equal("true", ep.Metadata["ClCompile.NoBuiltIn"]);
                    break;
                case "Develop":
                case "Release":
                    Assert.Equal("false", ep.Metadata["ClCompile.NoBuiltIn"]);
                    break;
                default:
                    Assert.True(false, string.Format("未知の BuildType です: {0}", conf.BuildType));
                    break;
            }
        }
    }
}
