﻿using System;
using System.Text;
using System.Collections.Generic;
using Xunit;

namespace PropertySheetsTest.TestCase.ItemMetadata
{
    public class ClCompileMultiProcessorCompilation : PropertySheetsTest
    {
        protected override void InvokeAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            if (!conf.IsWinPlatform)
            {
                return;
            }

            switch (conf.SubRootName)
            {
                case "Alice":
                case "Chris":
                case "Eris":
                case "Iris":
                case "NintendoWare":
                    Assert.Equal("true", ep.Metadata["ClCompile.MultiProcessorCompilation"]);
                    break;
                case "Samples":
                case "Tests":
                case "Users":
                    Assert.False(ep.Metadata.ContainsKey("ClCompile.MultiProcessorCompilation"));
                    break;
                default:
                    throw new ArgumentException(string.Format("{0}: 未知の SubRootName です。", conf.SubRootName), "conf");
            }
        }
    }
}
