﻿using System;
using System.Text;
using System.Collections.Generic;
using Xunit;

namespace PropertySheetsTest.TestCase.ItemMetadata
{
    public class ClCompileMinimalRebuild : PropertySheetsTest
    {
        protected override void InvokeAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            if (!conf.IsWinPlatform)
            {
                return;
            }

            switch (conf.SubRootName)
            {
                case "Alice":
                case "Chris":
                case "Eris":
                case "Iris":
                case "NintendoWare":
                    Assert.Equal("false", ep.Metadata["ClCompile.MinimalRebuild"]);
                    break;
                case "Samples":
                case "Tests":
                case "Users":
                    var defaultProject = GetDefaultVcProject(conf)[conf.ConfigurationPair];
                    Assert.Equal(defaultProject.Metadata["ClCompile.MinimalRebuild"], ep.Metadata["ClCompile.MinimalRebuild"]);
                    break;
                default:
                    throw new ArgumentException(string.Format("{0}: 未知の SubRootName です。", conf.SubRootName), "conf");
            }
        }
    }
}
