﻿using System;
using System.Text;
using System.Collections.Generic;
using Xunit;

namespace PropertySheetsTest.TestCase.ItemMetadata
{
    public class ClCompileLanguageStandard : PropertySheetsTest
    {
        protected override void InvokeAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            if (!conf.IsWinPlatform)
            {
                return;
            }

            switch (conf.PlatformToolset)
            {
                case "v120":
                case "v140":
                    // v140 までは本メタデータは存在しない
                    break;
                case "v141":
                    Assert.Equal("stdcpp14", ep.Metadata["ClCompile.LanguageStandard"]);
                    break;
                default:
                    throw new ArgumentException($"不明な PlatformToolset です: {conf.PlatformToolset}", nameof(conf.PlatformToolset));
            }
        }
    }
}
