﻿using System;
using System.Linq;
using System.Text;
using System.Collections.Generic;
using Xunit;

namespace PropertySheetsTest.TestCase.ItemMetadata
{
    public class ClCompileDebugInformationFormat : PropertySheetsTest
    {
        protected override void InvokeAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            if (!conf.IsWinPlatform)
            {
                return;
            }

            switch (conf.SubRootName)
            {
                case "Alice":
                case "Chris":
                case "Eris":
                case "Iris":
                case "NintendoWare":
                case "Samples":
                case "Tests":
                case "Users":
                    // 手元でビルドする場合の設定なので、Programs のライブラリも同じでよい。
                    //
                    // Debug ビルドの場合は EditAndContinue とする
                    // ただし VS2013 では x64 プラットフォームの EditAndContinue はサポートされていない (D9038 の警告が出る) ので ProgramDatabase を使用する
                    if (conf.BuildType == "Debug" && !(conf.Platform == "x64" && conf.PlatformToolset == "v120"))
                    {
                        Assert.Equal("EditAndContinue", ep.Metadata["ClCompile.DebugInformationFormat"]);
                    }
                    else
                    {
                        Assert.Equal("ProgramDatabase", ep.Metadata["ClCompile.DebugInformationFormat"]);
                    }
                    break;
                default:
                    throw new ArgumentException(string.Format("{0}: 未知の SubRootName です。", conf.SubRootName), "conf");
            }
        }
    }

    public class ClCompileDebugInformationFormatReleaseCheck : PropertySheetsTest
    {
        private static readonly IDictionary<string, string> globalProperties = new Dictionary<string, string>()
        {
            {"_NintendoSdkDebugInfoGenerationEnabled", "false"},
        };

        protected override VcProject GetVcProject(TestConfiguration conf)
        {
            return ProjectRepository.GetVcProject(conf, globalProperties);
        }

        protected override void InvokeAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            if (!conf.IsWinPlatform)
            {
                return;
            }
            if (SdkRootInfo.Environment != SdkEnvironment.Development)
            {
                // don't care
                return;
            }

            switch (conf.SubRootName)
            {
                case "Alice":
                case "Chris":
                case "Eris":
                case "Iris":
                case "NintendoWare":
                case "Samples":
                case "Tests":
                    Assert.Equal(string.Empty, ep.Metadata["ClCompile.DebugInformationFormat"]);
                    break;
                default:
                    throw new ArgumentException(string.Format("{0}: 未知の SubRootName です。", conf.SubRootName), "conf");
            }
        }
    }
}
