﻿using System.Text;
using System.Collections.Generic;
using System.Linq;
using System;
using Xunit;

namespace PropertySheetsTest.TestCase.ItemMetadata
{
    public class ClCompileAdditionalOptions : PropertySheetsTest
    {
        protected override void InvokeAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            switch (conf.Platform)
            {
                case "Win32":
                case "x64":
                    InvokeWinPlatformAssertions(conf, ep, expander);
                    break;
                case "NX32":
                case "NX64":
                    InvokeNXPlatformAssertions(conf, ep, expander);
                    break;
                default:
                    Assert.True(false, string.Format("未知の Platform です: {0}", conf.Platform));
                    break;
            }
        }

        private void InvokeWinPlatformAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            if (SdkRootInfo.Environment == SdkEnvironment.Development
                && conf.SubRootName == "Samples"
                && conf.ProjectType == ProjectType.Program)  // FIXME
            {
                switch (conf.PlatformToolset)
                {
                    case "v120":
                    case "v140":
                        AssertUtil.AssertOrderedSequenceEqual(
                            Util.TokenizeCommandLineOptions(ep.Metadata["ClCompile.AdditionalOptions"]),
                            new[] { "/w44668", "/wd4668", "/bigobj" });
                        break;
                    case "v141":
                        // https://developercommunity.visualstudio.com/content/problem/50686/windows-sdk-100150630-corecrt-mathh-missing-define.html
                        // UCRT 10.0.15063.0 の corecrt_math.h を x86 コンパイルすると C4668 警告が出るため、どうしようもないので警告を無効にする
                        // /Zc:twoPhase- は特定の VCToolsVersion のバグを回避するために付加しているため、無視する。
                        if (conf.Platform == "Win32")
                        {
                            AssertUtil.AssertOrderedSequenceEqual(
                               Util.TokenizeCommandLineOptions(ep.Metadata["ClCompile.AdditionalOptions"]).Where(x => x != "/Zc:twoPhase-"),
                               new[] { "/permissive-", "/wd4668", "/bigobj" });
                        }
                        else
                        {
                            AssertUtil.AssertOrderedSequenceEqual(
                               Util.TokenizeCommandLineOptions(ep.Metadata["ClCompile.AdditionalOptions"]).Where(x => x != "/Zc:twoPhase-"),
                               new[] { "/w44668", "/permissive-", "/wd4668", "/bigobj" });
                        }
                        break;
                    default:
                        throw new ArgumentException($"不明な PlatformToolset です: {conf.PlatformToolset}", nameof(conf.PlatformToolset));
                }
            }
            else
            {
                switch (conf.PlatformToolset)
                {
                    case "v120":
                    case "v140":
                        // SDK の成果物についてのみ /bigobj を付加する (SIGLO-62540)
                        switch (conf.SubRootName)
                        {
                            case "Alice":
                            case "Chris":
                            case "Eris":
                            case "Iris":
                            case "NintendoWare":
                            case "Tests":
                            case "Samples":
                                AssertUtil.AssertOrderedSequenceEqual(
                                    Util.TokenizeCommandLineOptions(ep.Metadata["ClCompile.AdditionalOptions"]),
                                    new[] { "/w44668", "/bigobj" });
                                break;
                            case "Users":
                                AssertUtil.AssertOrderedSequenceEqual(
                                    Util.TokenizeCommandLineOptions(ep.Metadata["ClCompile.AdditionalOptions"]),
                                    new[] { "/w44668" });
                                break;
                            default:
                                throw new ArgumentException(string.Format("{0}: 未知の SubRootName です。", conf.SubRootName), "conf");
                        }
                        break;
                    case "v141":
                        switch (conf.SubRootName)
                        {
                            case "Alice":
                            case "Chris":
                            case "Eris":
                            case "Iris":
                            case "NintendoWare":
                            case "Tests":
                            case "Samples":
                                // https://developercommunity.visualstudio.com/content/problem/50686/windows-sdk-100150630-corecrt-mathh-missing-define.html
                                // UCRT 10.0.15063.0 の corecrt_math.h を x86 コンパイルすると C4668 警告が出るため、どうしようもないので警告を無効にする
                                // /Zc:twoPhase- は特定の VCToolsVersion のバグを回避するために付加しているため、無視する。
                                if (conf.Platform == "Win32")
                                {
                                    AssertUtil.AssertOrderedSequenceEqual(
                                        Util.TokenizeCommandLineOptions(ep.Metadata["ClCompile.AdditionalOptions"]).Where(x => x != "/Zc:twoPhase-"),
                                        new[] { "/permissive-", "/bigobj" });
                                }
                                else
                                {
                                    AssertUtil.AssertOrderedSequenceEqual(
                                        Util.TokenizeCommandLineOptions(ep.Metadata["ClCompile.AdditionalOptions"]).Where(x => x != "/Zc:twoPhase-"),
                                        new[] { "/w44668", "/permissive-", "/bigobj" });
                                }
                                break;
                            case "Users":
                                // https://developercommunity.visualstudio.com/content/problem/50686/windows-sdk-100150630-corecrt-mathh-missing-define.html
                                // UCRT 10.0.15063.0 の corecrt_math.h を x86 コンパイルすると C4668 警告が出るため、どうしようもないので警告を無効にする
                                // /Zc:twoPhase- は特定の VCToolsVersion のバグを回避するために付加しているため、無視する。
                                if (conf.Platform == "Win32")
                                {
                                    AssertUtil.AssertOrderedSequenceEqual(
                                        Util.TokenizeCommandLineOptions(ep.Metadata["ClCompile.AdditionalOptions"]).Where(x => x != "/Zc:twoPhase-"),
                                        new[] { "/permissive-" });
                                }
                                else
                                {
                                    AssertUtil.AssertOrderedSequenceEqual(
                                        Util.TokenizeCommandLineOptions(ep.Metadata["ClCompile.AdditionalOptions"]).Where(x => x != "/Zc:twoPhase-"),
                                        new[] { "/w44668", "/permissive-" });
                                }
                                break;
                        }
                        break;
                    default:
                        throw new ArgumentException($"不明な PlatformToolset です: {conf.PlatformToolset}", nameof(conf.PlatformToolset));
                }
            }
        }

        private void InvokeNXPlatformAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            var options = Util.TokenizeCommandLineOptions(ep.Metadata["ClCompile.AdditionalOptions"])
                // Oasis が付加する Intellisense の設定を除く
                .Where(x => !x.StartsWith("/FI"));

            if (conf.SubRootName == "Users")
            {
                AssertUtil.AssertSequenceEqual(
                    options,
                    new string[] { });
            }
            else
            {
                AssertUtil.AssertOrderedSequenceEqual(
                    options,
                    new[] { "-Wstrict-aliasing", "-Werror=return-type", "-Wover-aligned" });
            }
        }
    }
}
