﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace PropertySheetsTest
{
    public enum SdkEnvironment
    {
        Development,
        User,
    }

    public class SdkRootInfo
    {
        public SdkRootInfo(string sdkRoot)
        {
            this.SdkRoot = sdkRoot;
            this.Environment = GetSdkEnvironment(sdkRoot);
        }

        public string SdkRoot { get; private set; }
        public SdkEnvironment Environment { get; private set; }

        public string Combine(string path)
        {
            return Path.Combine(SdkRoot, path);
        }

        public static SdkRootInfo SearchSdkRoot()
        {
            var sdkRootDirectoryName = Util.GetDirectoryNameOfFileAbove(
                Path.GetDirectoryName(System.Environment.CurrentDirectory),
                "NintendoSdkRootMark");
            if (sdkRootDirectoryName == null)
            {
                throw new ApplicationException("NintendoSdkRootMark が見つかりませんでした。");
            }
            return new SdkRootInfo(sdkRootDirectoryName);
        }

        private static SdkEnvironment GetSdkEnvironment(string sdkRoot)
        {
            if (File.Exists(Path.Combine(sdkRoot, "SigloRootMark")))
            {
                return SdkEnvironment.Development;
            }
            else
            {
                return SdkEnvironment.User;
            }
        }
    }
}
