<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

param
(
    [string[]]
    $Options
)

function Find-NintendoSdkRoot
{
    param
    (
        [string]
        $StartDirectory
    )

    $Directory = $StartDirectory
    while ($Directory)
    {
        if (Test-Path "$Directory\NintendoSdkRootMark")
        {
            return $Directory
        }
        $Directory = Split-Path $Directory
    }
}

$NintendoSdkRoot = Find-NintendoSdkRoot (Split-Path $MyInvocation.MyCommand.Path)
if (-not $NintendoSdkRoot)
{
    throw 'NintendoSdkRootMark not found'
}

$VsInstallationLocation = & "$NintendoSdkRoot\Integrate\CommandLineTools\LocateVsInstallation.exe"
if (-not (Test-Path $VsInstallationLocation))
{
    throw 'Visual Studio installation location not found'
}

$VsTestConsoleExe = "$VsInstallationLocation\Common7\IDE\CommonExtensions\Microsoft\TestWindow\vstest.console.exe"
if (-not (Test-Path $VsTestConsoleExe))
{
    throw 'vstest.console.exe not found'
}

& $VsTestConsoleExe @Options
exit $LastExitCode
