﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdlib>
#include <nnt.h>
#include <nn/nn_Log.h>
#include <nn/bgtc.h>
#include <nn/bgtc/bgtc_StateControlApi.h>
#include <nn/psm/psm_SystemApi.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/util/util_FormatString.h>
#include <nn/result/result_HandlingUtility.h>

#include "bgtc_BatterySaver.cpp"
#define FULL

namespace {

using namespace nn;
using namespace nn::bgtc;

class BgtcBatterySaverTest : public ::testing::Test
{
protected:
    BgtcBatterySaverTest()
    {
    }
    static void SetUpTestCase()
    {

    }
};

}

namespace nn { namespace bgtc {

Time g_Now = 0;

Time GetNow()
{
    return g_Now;
}

void SetNow(Time now)
{
    g_Now = now;
}

}}

namespace nn { namespace psm {

int g_BatteryChargePercentage = 50;

int GetBatteryChargePercentage() NN_NOEXCEPT
{
    return g_BatteryChargePercentage;
}

void SetBatteryChargePercentage(int value)
{
    g_BatteryChargePercentage = value;
}

ChargerType g_ChargerType = nn::psm::ChargerType_EnoughPower;

ChargerType GetChargerType() NN_NOEXCEPT
{
    return g_ChargerType;
}

void SetChargerType(ChargerType type)
{
    g_ChargerType = type;
}

}}

TEST_F(BgtcBatterySaverTest, Interval)
{
    nn::Result result;
    Interval interval;

    BatterySaver bs;
    //BatterySaver::OperationMode mode = bs.JudgeOperationMode();

    SetNow(10000);
    bs.NotifyFullAwakeOrHalfAwakeLeaving();

    SetNow(10050);
    interval = bs.CalculateHalfAwakeInterval(OperationMode_Active,  10051, true);
    GTEST_ASSERT_EQ(interval, 1);

    interval = bs.CalculateHalfAwakeInterval(OperationMode_Balance,  10051, false);
    GTEST_ASSERT_EQ(interval, 1);

    interval = bs.CalculateHalfAwakeInterval(OperationMode_Balance,  10051, true);
    GTEST_ASSERT_EQ(interval, bs.GetHalfAwakeMinimumInterval(OperationMode_Balance) - 50);

    interval = bs.CalculateHalfAwakeInterval(OperationMode_Save,    10051, true);
    GTEST_ASSERT_EQ(interval, bs.GetHalfAwakeMinimumInterval(OperationMode_Save)   - 50);

    interval = bs.CalculateHalfAwakeInterval(OperationMode_Balance,
        10050 + bs.GetHalfAwakeMinimumInterval(OperationMode_Balance) + 10, true);
    GTEST_ASSERT_EQ(interval, bs.GetHalfAwakeMinimumInterval(OperationMode_Balance) + 10);

}

extern "C" void nnMain()
{
    int result = 1;
    int     argc = nnt::GetHostArgc();
    char**  argv = nnt::GetHostArgv();

    ::testing::InitGoogleTest(&argc, argv);

    result = RUN_ALL_TESTS();

    // Windows ではグローバル変数のデストラクタ関係でうまく終了できないので Exit しない
#ifndef NN_BUILD_CONFIG_OS_WIN
    nnt::Exit(result);
#endif
}
