﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdint>
#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>

const double piApproximateValue = 3.1415926535897932384626433832795;
const uint32_t log2N = 9;
const uint32_t numberOfPoints = 1 << log2N;

int32_t initializeFft() NN_NOEXCEPT;
void    destroyFft() NN_NOEXCEPT;
void    calculateFft(int16_t* pBuffer, uint32_t pitch, uint32_t index) NN_NOEXCEPT;
