﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>
#include <nn/util/util_BitUtil.h>
#include <nn/nn_Common.h>

#include "../../../../../Programs/Eris/Sources/Libraries/audio/common/audio_NodeIdManager.h"

#if !defined(NN_SDK_BUILD_RELEASE)
TEST(GetNodeId, Precondition)
{
    const nn::audio::common::NodeIdManager::NodeIdType types[] = {
        static_cast<nn::audio::common::NodeIdManager::NodeIdType>(-1),
        static_cast<nn::audio::common::NodeIdManager::NodeIdType>(static_cast<int>(nn::audio::common::NodeIdManager::NodeIdType::Mix) + 1)
    };
    const int bases[] = { -1, nn::audio::common::NodeIdManager::BaseMax + 1 };
    const int variations[] = { -1, nn::audio::common::NodeIdManager::VariationMax + 1 };

    for(const auto type : types)
    {
        for(const auto base : bases)
        {
            for(const auto variation : variations)
            {
                EXPECT_DEATH_IF_SUPPORTED(nn::audio::common::NodeIdManager::GetNodeId(type, base, variation), "");
            }
        }
    }
}
#endif

TEST(GetNodeId, Success)
{
    const nn::audio::common::NodeIdManager::NodeIdType types[] = { nn::audio::common::NodeIdManager::NodeIdType::Voice, nn::audio::common::NodeIdManager::NodeIdType::Mix };
    const int bases[] = { 0, nn::audio::common::NodeIdManager::BaseMax / 2, nn::audio::common::NodeIdManager::BaseMax };
    const int variations[] = { 0, nn::audio::common::NodeIdManager::VariationMax / 2, nn::audio::common::NodeIdManager::VariationMax };

    for(const auto type : types)
    {
        for(const auto base : bases)
        {
            for(const auto variation : variations)
            {
                const auto nodeId = nn::audio::common::NodeIdManager::GetNodeId(type, base, variation);
                EXPECT_EQ(type, nn::audio::common::NodeIdManager::GetType(nodeId));
                EXPECT_EQ(base, nn::audio::common::NodeIdManager::GetBase(nodeId));
                EXPECT_EQ(variation, nn::audio::common::NodeIdManager::GetVariation(nodeId));
            }
        }
    }
}
