﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/audio.h>

class ScopedGameRecord
{
public:
    ScopedGameRecord() : m_GameRecord()
    {
    }
    ~ScopedGameRecord()
    {
        if (nn::audio::GetFinalOutputRecorderState(&m_GameRecord) == nn::audio::FinalOutputRecorderState_Started)
        {
            nn::audio::StopFinalOutputRecorder(&m_GameRecord);
        }
        nn::audio::CloseFinalOutputRecorder(&m_GameRecord);
    }
    nn::audio::FinalOutputRecorder* operator->()
    {
        return &m_GameRecord;
    }
    nn::audio::FinalOutputRecorder* Get()
    {
        return &m_GameRecord;
    }
private:
    nn::audio::FinalOutputRecorder m_GameRecord;
};

