﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>

#include <limits>
#include <random>

#include "../../Programs/Eris/Sources/Libraries/audio/server/detail/audio_UacVolume.h"

TEST(UacVolume, CompareX1X2AndX4)
{
    const int SampleCount = 1024;

    int16_t input[SampleCount];
    int16_t output0[SampleCount] = { 0 };
    int16_t output1[SampleCount] = { 0 };

    std::mt19937 mt(0);
    for (auto i = 0; i < SampleCount; ++i)
    {
        const auto a = std::numeric_limits<uint16_t>::max();
        const auto b = std::numeric_limits<int16_t>::min();
        input[i] = (mt() % a) + b;
        output0[i] = output1[i] = ( mt() % a) + b;
    }

    const int32_t volumes[] = { 32768, 32767, 12345, 0 };
    for (const auto volume : volumes)
    {
        nn::audio::server::detail::ApplyUniformGain1(output0, input, volume, SampleCount);
        nn::audio::server::detail::ApplyUniformGain4(output1, input, volume, SampleCount);
        for (auto i = 0; i < SampleCount; ++i)
        {
            EXPECT_EQ(output0[i], output1[i]);
        }
    }
}

