﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>

#include <limits>
#include <random>

#include "../../Programs/Eris/Sources/Libraries/audio/dsp/audio_Mix.h"

TEST(FloatDspMix, CompareX1AndX4)
{
    const int SampleCount = 1024;

    float input[SampleCount];
    float output0[SampleCount] = { 0 };
    float output1[SampleCount] = { 0 };

    std::mt19937 mt(0);
    for (auto i = 0; i < SampleCount; ++i)
    {
        const auto a = std::numeric_limits<uint16_t>::max();
        const auto b = std::numeric_limits<int16_t>::min();
        input[i] = static_cast<float>((static_cast<uint16_t>(mt()) % a) + b) / 32768.0f;
        output0[i] = output1[i] = static_cast<float>((static_cast<uint16_t>(mt()) % a) + b) / 32768.0f;
    }

    const float volumes[] = { 1.414f, 0.707f, 0.0f, -0.707f, -1.414f };
    for (const auto volume : volumes)
    {
        nn::audio::dsp::ApplyMix1(output0, input, volume, SampleCount);
        nn::audio::dsp::ApplyMix4(output1, input, volume, SampleCount);
        for (auto i = 0; i < SampleCount; ++i)
        {
            EXPECT_EQ(output0[i], output1[i]);
        }
    }
}

TEST(FloatDspMixRamp, CompareX1AndX4)
{
    const int SampleCount = 1024;

    float input[SampleCount];
    float output0[SampleCount] = { 0 };
    float output1[SampleCount] = { 0 };

    std::mt19937 mt(0);
    for (auto i = 0; i < SampleCount; ++i)
    {
        const auto a = std::numeric_limits<uint16_t>::max();
        const auto b = std::numeric_limits<int16_t>::min();
        input[i] = static_cast<float>((static_cast<uint16_t>(mt()) % a) + b) / 32768.0f;
        output0[i] = output1[i] = static_cast<float>((static_cast<uint16_t>(mt()) % a) + b) / 32768.0f;
    }

    const float volumes[] = { 1.414f, 0.707f, 0.0f, -0.707f, -1.414f };
    const float deltas[] = { -0.0001f, -0.001f, 0.0f, 0.001f, 0.0001f };
    for (const auto volume : volumes)
    {
        for (const auto delta : deltas)
        {
            nn::audio::dsp::ApplyMixRamp1(output0, input, volume, delta, SampleCount);
            nn::audio::dsp::ApplyMixRamp4(output1, input, volume, delta, SampleCount);
            for (auto i = 0; i < SampleCount; ++i)
            {
//                 // TODO: diff is bigger than expected...
//                 EXPECT_FLOAT_EQ(output0[i], output1[i]);
            }
        }
    }
}

#if defined(__ARM_NEON__) || defined(__ARM_NEON)
namespace generic {

#include "../../Programs/Eris/Sources/Libraries/audio/dsp/detail/audio_Mix.generic.h"

}  // namespace negeric

namespace neon {

#include "../../Programs/Eris/Sources/Libraries/audio/dsp/detail/audio_Mix.neon.h"

}  // namespace neon

TEST(FloatDspMix, CompareGenericAndNeon)
{
    const int SampleCount = 1024;

    float input[SampleCount];
    float output0[SampleCount] = { 0 };
    float output1[SampleCount] = { 0 };

    std::mt19937 mt(0);
    for (auto i = 0; i < SampleCount; ++i)
    {
        const auto a = std::numeric_limits<uint16_t>::max();
        const auto b = std::numeric_limits<int16_t>::min();
        input[i] = static_cast<float>((static_cast<uint16_t>(mt()) % a) + b) / 32768.0f;
        output0[i] = output1[i] = static_cast<float>((static_cast<uint16_t>(mt()) % a) + b) / 32768.0f;
    }

    const float volumes[] = { 1.414f, 0.707f, 0.0f, -0.707f, -1.414f };
    for (const auto volume : volumes)
    {
        generic::nn::audio::dsp::detail::ApplyMix4(output0, input, volume, SampleCount);
        neon::nn::audio::dsp::detail::ApplyMix4(output1, input, volume, SampleCount);
        for (auto i = 0; i < SampleCount; ++i)
        {
            EXPECT_EQ(output0[i], output1[i]);
        }
    }
}

TEST(FloatDspMixRamp, CompareGenericAndNeon)
{
    const int SampleCount = 1024;

    float input[SampleCount];
    float output0[SampleCount] = { 0 };
    float output1[SampleCount] = { 0 };

    std::mt19937 mt(0);
    for (auto i = 0; i < SampleCount; ++i)
    {
        const auto a = std::numeric_limits<uint16_t>::max();
        const auto b = std::numeric_limits<int16_t>::min();
        input[i] = static_cast<float>((static_cast<uint16_t>(mt()) % a) + b) / 32768.0f;
        output0[i] = output1[i] = static_cast<float>((static_cast<uint16_t>(mt()) % a) + b) / 32768.0f;
    }

    const float volumes[] = { 1.414f, 0.707f, 0.0f, -0.707f, -1.414f };
    const float deltas[] = { -0.0001f, -0.001f, 0.0f, 0.001f, 0.0001f };
    for (const auto volume : volumes)
    {
        for (const auto delta : deltas)
        {
            generic::nn::audio::dsp::detail::ApplyMixRamp4(output0, input, volume, delta, SampleCount);
            neon::nn::audio::dsp::detail::ApplyMixRamp4(output1, input, volume, delta, SampleCount);
            for (auto i = 0; i < SampleCount; ++i)
            {
                EXPECT_EQ(output0[i], output1[i]);
            }
        }
    }
}
#endif  // defined(__ARM_NEON__) || defined(__ARM_NEON)
