﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/audio.h>

class ScopedAudioIn
{
public:
    ScopedAudioIn() : m_AudioIn()
    {
    }
    ~ScopedAudioIn()
    {
        if (nn::audio::GetAudioInState(&m_AudioIn) == nn::audio::AudioInState_Started)
        {
            nn::audio::StopAudioIn(&m_AudioIn);
        }
        nn::audio::CloseAudioIn(&m_AudioIn);
    }
    nn::audio::AudioIn* operator->()
    {
        return &m_AudioIn;
    }
    nn::audio::AudioIn* Get()
    {
        return &m_AudioIn;
    }
private:
    nn::audio::AudioIn m_AudioIn;
};

