﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include "common.fsid"

#include <nnt.h>
#include <nnt/atkUtil/testAtk_Util.h>
#include <nnt/atkUtil/testAtk_CommonSetup.h>
#include <nn/atk.h>
#include <nn/nn_Log.h>
#include <nn/mem.h>

namespace {

const int MemoryHeapSize = 32 * 1024 * 1024;

nnt::atk::util::FsCommonSetup   g_FsSetup;
nnt::atk::util::AtkCommonSetup  g_AtkSetup;

static char g_HeapMemory[MemoryHeapSize];
nn::mem::StandardAllocator  g_Allocator;

void LoadData()
{
    g_AtkSetup.LoadData(SEQ_MARIOKART, "SEQ_MARIOKART");
    g_AtkSetup.LoadData(WSD_SNARE, "WSD_SNARE");
}

}

TEST( SoundActor, ShareActorPlayerTest )
{
    nnt::atk::util::OnPreAtkTest();
    g_Allocator.Initialize( g_HeapMemory, MemoryHeapSize );
    g_FsSetup.Initialize();
    g_AtkSetup.Initialize( g_Allocator );
    LoadData();

    nn::atk::SoundActor m_SoundActor1;
    nn::atk::SoundActor m_SoundActor2;
    nn::atk::SoundActor::ActorPlayer m_ActorPlayer;

    nn::atk::SoundArchivePlayer& soundArchivePlayer = g_AtkSetup.GetSoundArchivePlayer();
    nn::atk::SoundHandle soundHandle;

    m_SoundActor1.Initialize( &soundArchivePlayer, &m_ActorPlayer );
    m_SoundActor2.Initialize( &soundArchivePlayer, &m_ActorPlayer );

    EXPECT_TRUE( m_SoundActor1.StartSound( &soundHandle, STRM_MARIOKART ).IsSuccess() );
    EXPECT_TRUE( m_SoundActor2.StartSound( &soundHandle, STRM_MARIOKART ).IsSuccess() );

    m_SoundActor1.Finalize();
    m_SoundActor2.Finalize();

    g_AtkSetup.Finalize( g_Allocator );
    g_FsSetup.Finalize();
    g_Allocator.Finalize();
}
