﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/atkUtil/testAtk_SoundThreadStatistics.h>
#include <nn/nn_Log.h>

namespace nnt { namespace atk { namespace util {

    SoundThreadStatistics::SoundThreadStatistics(int offset) NN_NOEXCEPT
        : m_OffsetCount(offset)
    {
    }

    SoundThreadStatistics::SoundThreadStatistics() NN_NOEXCEPT
        : m_OffsetCount(0)
    {
    }

    void SoundThreadStatistics::AddProfile(nn::atk::SoundThreadUpdateProfile& profile) NN_NOEXCEPT
    {
        if(m_OffsetCount > 0)
        {
            --m_OffsetCount;
            return;
        }

        m_SoundThreadProcess.AddData(profile.soundThreadProcess.GetSpan().GetMicroSeconds());
        m_UpdateLowLevelVoiceProcess.AddData(profile._updateLowLevelVoiceProcess.GetSpan().GetMicroSeconds());
        m_FrameProcess.AddData(profile._frameProcess.GetSpan().GetMicroSeconds());
        m_UserEffectProcess.AddData(profile._userEffectFrameProcess.GetSpan().GetMicroSeconds());
        m_UpdateRendererProcess.AddData(profile._updateRendererProcess.GetSpan().GetMicroSeconds());
        m_WaitRendererEventProcess.AddData(profile._waitRendererEventProcess.GetSpan().GetMicroSeconds());
    }

    void SoundThreadStatistics::PrintMeanProfile(const char* label) NN_NOEXCEPT
    {
        NN_LOG("##teamcity[buildStatisticValue key='%s_SoundThreadProcessAverage(us)' value='%f']\n", label, m_SoundThreadProcess.GetMean());
        NN_LOG("##teamcity[buildStatisticValue key='%s_UpdateLowLevelVoiceAverage(us)' value='%f']\n", label, m_UpdateLowLevelVoiceProcess.GetMean());
        NN_LOG("##teamcity[buildStatisticValue key='%s_FrameProcessAverage(us)' value='%f']\n", label, m_FrameProcess.GetMean());
        NN_LOG("##teamcity[buildStatisticValue key='%s_UserEffectAverage(us)' value='%f']\n", label, m_UserEffectProcess.GetMean());
        NN_LOG("##teamcity[buildStatisticValue key='%s_UpdateRendererAverage(us)' value='%f']\n", label, m_UpdateRendererProcess.GetMean());
        NN_LOG("##teamcity[buildStatisticValue key='%s_WaitRendererEventAverage(us)' value='%f']\n", label, m_WaitRendererEventProcess.GetMean());
    }

    void SoundThreadStatistics::PrintMaxProfile(const char* label) NN_NOEXCEPT
    {
        int64_t max = m_SoundThreadProcess.GetMax();
        NN_LOG("##teamcity[buildStatisticValue key='%sSoundThreadProcessMax(us)' value='%d']\n", label, static_cast<int>(max));
        max = m_UpdateLowLevelVoiceProcess.GetMax();
        NN_LOG("##teamcity[buildStatisticValue key='%sUpdateLowLevelVoiceMax(us)' value='%d']\n", label, static_cast<int>(max));
        max = m_FrameProcess.GetMax();
        NN_LOG("##teamcity[buildStatisticValue key='%sFrameProcessMax(us)' value='%d']\n", label, static_cast<int>(max));
        max = m_UserEffectProcess.GetMax();
        NN_LOG("##teamcity[buildStatisticValue key='%sUserEffectMax(us)' value='%d']\n", label, static_cast<int>(max));
        max = m_UpdateRendererProcess.GetMax();
        NN_LOG("##teamcity[buildStatisticValue key='%sUpdateRendererMax(us)' value='%d']\n", label, static_cast<int>(max));
        max = m_WaitRendererEventProcess.GetMax();
        NN_LOG("##teamcity[buildStatisticValue key='%sWaitRendererEventMax(us)' value='%d']\n", label, static_cast<int>(max));
    }

    void SoundThreadStatistics::Reset() NN_NOEXCEPT
    {
        m_SoundThreadProcess.ResetData();
        m_UpdateLowLevelVoiceProcess.ResetData();
        m_FrameProcess.ResetData();
        m_UserEffectProcess.ResetData();
        m_UpdateRendererProcess.ResetData();
        m_WaitRendererEventProcess.ResetData();
    }

}}}
