﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/atkUtil/testAtk_FsCommonSetup.h>
#include <nnt/atkUtil/testAtk_Util.h>

namespace nnt { namespace atk { namespace util {

const char* FsCommonSetup::RomMountName = "Rom";
const char* FsCommonSetup::ContentsMountName = "Contents";
const char* FsCommonSetup::TestResultsMountName = "TestResults";
const char* FsCommonSetup::TestBinariesMountName = "TestBinaries";
char FsCommonSetup::m_MountRomCacheBuffer[FsCommonSetup::MountRomCacheBufferSize] = {};

NN_DEFINE_STATIC_CONSTANT(const size_t FsCommonSetup::MountRomCacheBufferSize);

FsCommonSetup::FsCommonSetup() NN_NOEXCEPT
{
}

FsCommonSetup::~FsCommonSetup() NN_NOEXCEPT
{
}

////////////////////////////////////////////////////////////////////////////////////
// Setup Utility
////////////////////////////////////////////////////////////////////////////////////

void FsCommonSetup::Initialize() NN_NOEXCEPT
{
    Initialize(m_Param);
}

void FsCommonSetup::Initialize(FsCommonSetup::InitializeParam& param) NN_NOEXCEPT
{
    if(param.IsRomMounted())
    {
        size_t mountRomCacheUseSize = 0;
        nn::Result result = nn::fs::QueryMountRomCacheSize(&mountRomCacheUseSize);
        NN_ABORT_UNLESS_RESULT_SUCCESS(result);
        NN_ABORT_UNLESS_LESS_EQUAL(mountRomCacheUseSize, MountRomCacheBufferSize);

        result = nn::fs::MountRom(RomMountName, m_MountRomCacheBuffer, MountRomCacheBufferSize);
        NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    }
    if(param.IsContentsDirectoryMounted())
    {
        // +1 は終端文字の分
        char contentsDirectory[nn::fs::EntryNameLengthMax + 1];
        NN_ABORT_UNLESS(nnt::atk::util::GetContentsDirectoryPath(contentsDirectory, sizeof(contentsDirectory)), "Cannot get contents directory path.");
        // Contents ディレクトリのマウント
        nnt::atk::util::MountHostPcFs(ContentsMountName, contentsDirectory);
    }
    if(param.IsTestResultsDirectoryMounted())
    {
        // +1 は終端文字の分
        char testResultsDirectory[nn::fs::EntryNameLengthMax + 1];
        nnt::atk::util::GetTestResultsDirectoryPath(testResultsDirectory, sizeof(testResultsDirectory));
        nnt::atk::util::MountHostPcFs(TestResultsMountName, testResultsDirectory);
    }
    if(param.IsTestBinariesDirectoryMounted())
    {
        // +1 は終端文字の分
        char testBinariesDirectory[nn::fs::EntryNameLengthMax + 1];
        nnt::atk::util::GetAtkTestBinariesDirectoryPath(testBinariesDirectory, sizeof(testBinariesDirectory));
        nnt::atk::util::MountHostPcFs(TestBinariesMountName, testBinariesDirectory);
    }

    m_Param = param;
}

void FsCommonSetup::Finalize() NN_NOEXCEPT
{
    if(m_Param.IsRomMounted())
    {
        nn::fs::Unmount(RomMountName);
    }
    if(m_Param.IsContentsDirectoryMounted())
    {
        nn::fs::Unmount(ContentsMountName);
    }
    if(m_Param.IsTestResultsDirectoryMounted())
    {
        nn::fs::Unmount(TestResultsMountName);
    }
    if(m_Param.IsTestBinariesDirectoryMounted())
    {
        nn::fs::Unmount(TestBinariesMountName);
    }
}

}}}
