﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// HIPC によって Calculator サービスを利用するためのテストサンプル

// このテストでは、同一のテストプロセス内で、サーバとクライアントを動作させている。
// 実環境では、一般に、サーバとクライアントは別プロセスとなる。

#include <nnt/nntest.h>

#include <nn/sfsmpl/sfsmpl_CalculatorShim.h>
#include <nn/sfsmpl/sfsmpl_CalculatorHipcServer.h>

#include <nn/nn_Common.h>
#include <nn/os/os_Thread.h>

namespace {

// サーバ処理スレッド用グローバル変数とサーバ関数
NN_ALIGNAS(4096) char g_ServerStack[4096];
nn::os::ThreadType g_ServerThread;
void HipcServerFunction(void* arg) NN_NOEXCEPT
{
    NN_UNUSED(arg);
    // サーバループを実行
    // nn::sfsmpl::RequestStopCalculatorServer() が(別スレッドから)呼ばれるまで、ループし続ける
    nn::sfsmpl::LoopCalculatorServer();
}

void InitializeHipcServer() NN_NOEXCEPT
{
    // サーバの初期化
    nn::sfsmpl::InitializeCalculatorServer();

    // サーバ処理スレッドの作成
    auto result = nn::os::CreateThread(&g_ServerThread, &HipcServerFunction, nullptr, g_ServerStack, sizeof(g_ServerStack), 10);
    ASSERT_TRUE(result.IsSuccess());
    nn::os::StartThread(&g_ServerThread);
}

void FinalizeHipcServer() NN_NOEXCEPT
{
    // サーバ終了をリクエスト
    // サーバ処理スレッド中の nn::sfsmpl::LoopCalculatorServer の処理が返る。
    nn::sfsmpl::RequestStopCalculatorServer();

    // サーバ処理スレッド終了待機と破棄
    nn::os::WaitThread(&g_ServerThread);
    nn::os::DestroyThread(&g_ServerThread);

    // サーバの終了処理
    nn::sfsmpl::FinalizeCalculatorServer();
}

void ExecuteClient() NN_NOEXCEPT
{
    // InitializeCalculatorByHipc の呼び出し以外は、DFC の場合と共通コードとなる。
    nn::sfsmpl::InitializeCalculatorByHipc();

    EXPECT_EQ(1, nn::sfsmpl::Negate(-1));
    EXPECT_EQ(3, nn::sfsmpl::Add(1, 2));
    EXPECT_EQ(2, nn::sfsmpl::Sub(4, 2));

    nn::sfsmpl::FinalizeCalculator();
}

TEST(sfsmpl_Calculator, Hipc)
{
    // サーバの起動
    // サーバの処理は別スレッドで行われる。
    InitializeHipcServer();

    // クライアントコード(テストコード)の実行
    ExecuteClient();

    // サーバの終了
    FinalizeHipcServer();
}

}
