﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// DFC によって Calculator サービスを利用するためのテストサンプル

#include <nnt/nntest.h>

#include <nn/sfsmpl/sfsmpl_CalculatorShim.h>

#include <nn/nn_Common.h>
#include <nn/init.h>

extern "C" void nninitStartup()
{
}

namespace {

// DFC によるテスト
TEST(sfsmpl_Calculator, Dfc)
{
    nn::sfsmpl::InitializeCalculatorByDfc();

    EXPECT_EQ(1, nn::sfsmpl::Negate(-1));
    EXPECT_EQ(3, nn::sfsmpl::Add(1, 2));
    EXPECT_EQ(2, nn::sfsmpl::Sub(4, 2));

    nn::sfsmpl::FinalizeCalculator();
}

}
