﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/nntest.h>

// テスト対象
#include <nn/sf/sf_Out.h>

// 実装
#include <nn/nn_Common.h>
#include <type_traits>

#define MY_EXPECT_EQ(a, b) EXPECT_TRUE((a) == (b))

namespace {

template <typename Int>
void TestOutBasic()
{
    Int n = 0;
    nn::sf::Out<Int> o = &n;
    MY_EXPECT_EQ(0, o.Get());
    MY_EXPECT_EQ(0, n);
    o.Set(1);
    MY_EXPECT_EQ(1, o.Get());
    MY_EXPECT_EQ(1, n);
    auto o2 = o;
    o.Set(0);
    MY_EXPECT_EQ(0, o.Get());
    MY_EXPECT_EQ(0, o2.Get());
    MY_EXPECT_EQ(0, n);
}

template <typename Int>
void TestOutBasicBoth()
{
    TestOutBasic<typename std::make_signed<Int>::type>();
    TestOutBasic<typename std::make_unsigned<Int>::type>();
}

TEST(sf, Out_Basic)
{
    TestOutBasic<bool>();
    TestOutBasicBoth<char>();
    TestOutBasicBoth<char16_t>();
    TestOutBasicBoth<char32_t>();
    TestOutBasicBoth<wchar_t>();
    TestOutBasicBoth<short>();
    TestOutBasicBoth<int>();
    TestOutBasicBoth<long>();
    TestOutBasicBoth<long long>();
    TestOutBasicBoth<int8_t>();
    TestOutBasicBoth<int16_t>();
    TestOutBasicBoth<int32_t>();
}

} // anonymous namespace
