﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// このファイルはユーザ定義

#include "testSf_AllFunctionTestsImpl.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/nn_SdkAssert.h>
#include "testSf_IAllFunctionTests.sfdl.h"
#include <nn/sf/sf_ObjectFactory.h>
#include <nn/sf/sf_ContextControl.h>
#include <nn/sf/cmif/sf_InlineContext.h>
#include <nn/sf/sf_FsInlineContext.h>

namespace nnt { namespace testsf {

AllFunctionTestsImpl::AllFunctionTestsImpl(nn::sf::impl::ExpHeapAllocator* allocator, int x) NN_NOEXCEPT
    : m_Allocator(allocator)
    , m_IntValue(x)
    , m_ReturnedInvalidContext(false)
{
    this->m_SessionCount = 0;
}

int AllFunctionTestsImpl::EchoInt(int x) NN_NOEXCEPT
{
    return x;
}

nn::Result AllFunctionTestsImpl::StoreIntWithResult(int x) NN_NOEXCEPT
{
    this->m_IntValue = x;
    NN_RESULT_SUCCESS;
}

void AllFunctionTestsImpl::StoreInt(int x) NN_NOEXCEPT
{
    this->m_IntValue = x;
}

int AllFunctionTestsImpl::LoadInt() NN_NOEXCEPT
{
    return m_IntValue;
}

void AllFunctionTestsImpl::FlipBits(const nn::sf::OutBuffer& outBuffer, const nn::sf::InBuffer& inBuffer) NN_NOEXCEPT
{
    NN_SDK_ASSERT_EQUAL(outBuffer.GetSize(), inBuffer.GetSize());
    auto src = inBuffer.GetPointerUnsafe();
    auto dst = outBuffer.GetPointerUnsafe();
    for (size_t i = 0; i < outBuffer.GetSize(); ++i)
    {
        dst[i] = ~src[i];
    }
}

std::int32_t AllFunctionTestsImpl::Add(AddParameter p) NN_NOEXCEPT
{
    return p.a + p.b;
}

std::int32_t AllFunctionTestsImpl::SumAndSubBytes(const nn::sf::OutBuffer& outSum, const nn::sf::OutBuffer& outSub, const nn::sf::InBuffer& inBuffer1, const nn::sf::InBuffer& inBuffer2) NN_NOEXCEPT
{
    NN_SDK_ASSERT_EQUAL(inBuffer1.GetSize(), inBuffer2.GetSize());
    NN_SDK_ASSERT_EQUAL(inBuffer1.GetSize(), outSum.GetSize());
    NN_SDK_ASSERT_EQUAL(inBuffer1.GetSize(), outSub.GetSize());
    auto src1 = reinterpret_cast<const std::uint8_t*>(inBuffer1.GetPointerUnsafe());
    auto src2 = reinterpret_cast<const std::uint8_t*>(inBuffer2.GetPointerUnsafe());
    auto sum = reinterpret_cast<std::uint8_t*>(outSum.GetPointerUnsafe());
    auto sub = reinterpret_cast<std::uint8_t*>(outSub.GetPointerUnsafe());
    for (size_t i = 0; i < inBuffer1.GetSize(); ++i)
    {
        sum[i] = src1[i] + src2[i];
        sub[i] = src1[i] - src2[i];
    }
    return static_cast<std::int32_t>(inBuffer1.GetSize());
}

std::int32_t AllFunctionTestsImpl::SumAndSubBytes2(const nn::sf::OutBuffer& outSum, const nn::sf::OutBuffer& outSub, const nn::sf::InBuffer& inBuffer1, const nn::sf::InBuffer& inBuffer2) NN_NOEXCEPT
{
    return SumAndSubBytes(outSum, outSub, inBuffer1, inBuffer2);
}

std::int32_t AllFunctionTestsImpl::SumAndSubBytes3(const nn::sf::OutBuffer& outSum, const nn::sf::OutBuffer& outSub, const nn::sf::InBuffer& inBuffer1, const nn::sf::InBuffer& inBuffer2) NN_NOEXCEPT
{
    return SumAndSubBytes(outSum, outSub, inBuffer1, inBuffer2);
}

std::int32_t AllFunctionTestsImpl::SumAndSubBytes4(const nn::sf::OutBuffer& outSum, const nn::sf::OutBuffer& outSub, const nn::sf::InBuffer& inBuffer1, const nn::sf::InBuffer& inBuffer2) NN_NOEXCEPT
{
    return SumAndSubBytes(outSum, outSub, inBuffer1, inBuffer2);
}

void AllFunctionTestsImpl::LoadIntByOut(nn::sf::Out<int> pOut) NN_NOEXCEPT
{
    pOut.Set(m_IntValue);
}

nnt::testsf::Struct2 AllFunctionTestsImpl::EchoStruct(const nnt::testsf::Struct1& s) NN_NOEXCEPT
{
    nnt::testsf::Struct2 ret;
    ret.addParameter = s.addParameter;
    ret.b = s.b;
    ret.c = s.c;
    ret.c16 = s.c16;
    ret.c32 = s.c32;
    ret.i8 = s.i8;
    ret.i16 = s.i16;
    ret.i32 = s.i32;
    ret.i64 = s.i64;
    return ret;
}

void AllFunctionTestsImpl::EchoStruct2(nn::sf::Out<nnt::testsf::Struct2> pOut, const nnt::testsf::Struct1& s) NN_NOEXCEPT
{
    pOut.Set(EchoStruct(s));
}

class AllFunctionTestsImpl::SessionImpl
{
private:

    nn::sf::SharedPointer<AllFunctionTestsImpl> m_Parent;
    int m_Value;

public:

    explicit SessionImpl(AllFunctionTestsImpl* parent, int n) NN_NOEXCEPT
        : m_Parent(parent, true)
        , m_Value(n)
    {
        ++m_Parent->m_SessionCount;
    }

    ~SessionImpl() NN_NOEXCEPT
    {
        --m_Parent->m_SessionCount;
    }

    int GetValue() NN_NOEXCEPT
    {
        return m_Value;
    }

};

nn::sf::SharedPointer<nnt::testsf::ITestSession> AllFunctionTestsImpl::OpenSession(int value) NN_NOEXCEPT
{
    typedef nn::sf::ObjectFactory<nn::sf::impl::ExpHeapAllocator::Policy> Factory;
    return Factory::CreateSharedEmplaced<
        nnt::testsf::ITestSession,
        nnt::testsf::AllFunctionTestsImpl::SessionImpl
    >(m_Allocator, this, value);
}

void AllFunctionTestsImpl::OpenSession2(nn::sf::Out<nn::sf::SharedPointer<nnt::testsf::ITestSession>> pOut, int value) NN_NOEXCEPT
{
    pOut.Set(OpenSession(value));
}

void AllFunctionTestsImpl::OpenSessionChar(nn::sf::Out<nn::sf::SharedPointer<nnt::testsf::ITestSession>> pOut, nn::sf::Out<char> pCharOut, char x) NN_NOEXCEPT
{
    *pCharOut = x;
    pOut.Set(OpenSession(static_cast<int>(x)));
}

int AllFunctionTestsImpl::GetSessionCount() NN_NOEXCEPT
{
    return m_SessionCount.load();
}

void AllFunctionTestsImpl::SetNativeHandleForTest(nn::sf::NativeHandle&& handle) NN_NOEXCEPT
{
    this->m_NativeHandle = std::move(handle);
}

nn::sf::NativeHandle AllFunctionTestsImpl::GetNativeHandle() NN_NOEXCEPT
{
    NN_SDK_ASSERT(m_NativeHandle.IsManaged());
    return std::move(m_NativeHandle);
}

void AllFunctionTestsImpl::GetNativeHandle2(nn::sf::Out<nn::sf::NativeHandle> pOut) NN_NOEXCEPT
{
    pOut.Set(m_NativeHandle.GetShared());
}

void AllFunctionTestsImpl::MoveNativeHandle(nn::sf::Out<nn::sf::NativeHandle> pOut) NN_NOEXCEPT
{
    NN_SDK_ASSERT(m_NativeHandle.IsManaged());
    pOut.Set(std::move(m_NativeHandle));
}

void AllFunctionTestsImpl::InNativeHandle(nn::sf::NativeHandle&& e) NN_NOEXCEPT
{
    this->m_NativeHandle = std::move(e);
}

void AllFunctionTestsImpl::MoveInNativeHandle(nn::sf::NativeHandle&& e) NN_NOEXCEPT
{
    this->m_NativeHandle = std::move(e);
}

void AllFunctionTestsImpl::SetClientProcessId(nn::Bit64 pid) NN_NOEXCEPT
{
    this->m_ClientProcessId = pid;
}

void AllFunctionTestsImpl::GetClientProcessId(nn::sf::Out<nn::Bit64> pOut) NN_NOEXCEPT
{
    pOut.Set(this->m_ClientProcessId);
}

void AllFunctionTestsImpl::SquareArrayElement(const nn::sf::OutArray<std::int32_t>& dst, const nn::sf::InArray<std::int32_t>& src) NN_NOEXCEPT
{
    NN_SDK_ASSERT_EQUAL(dst.GetLength(), src.GetLength());
    for (size_t i = 0; i < dst.GetLength(); ++i)
    {
        dst[i] = src[i] * src[i];
    }
}

void AllFunctionTestsImpl::SquareArrayElement2(const nn::sf::OutArray<std::int32_t>& dst, const nn::sf::InArray<std::int32_t>& src) NN_NOEXCEPT
{
    SquareArrayElement(dst, src);
}

void AllFunctionTestsImpl::EchoStruct3(nn::sf::Out<nnt::testsf::Struct2> pOut, const nnt::testsf::Struct1& s) NN_NOEXCEPT
{
    pOut.Set(EchoStruct(s));
}

void AllFunctionTestsImpl::EchoStruct4(nn::sf::Out<nnt::testsf::Struct2> pOut, const nnt::testsf::Struct1& s) NN_NOEXCEPT
{
    pOut.Set(EchoStruct(s));
}

void AllFunctionTestsImpl::MoveNativeHandle2(nn::sf::Out<nn::sf::NativeHandle> pOut) NN_NOEXCEPT
{
    NN_SDK_ASSERT(m_NativeHandle.IsManaged());
    pOut.Set(std::move(m_NativeHandle));
}

bool AllFunctionTestsImpl::EchoBool(bool x) NN_NOEXCEPT
{
    return x;
}

std::uint16_t AllFunctionTestsImpl::EchoUInt16(std::uint16_t x) NN_NOEXCEPT
{
    return x;
}

std::uint64_t AllFunctionTestsImpl::EchoUInt64(std::uint64_t x) NN_NOEXCEPT
{
    return x;
}

nn::Result AllFunctionTestsImpl::DeferProcess() NN_NOEXCEPT
{
    if (!m_ReturnedInvalidContext)
    {
        this->m_ReturnedInvalidContext = true;
        NN_RESULT_THROW(nn::sf::DeferProcess());
    }
    NN_RESULT_SUCCESS;
}

nn::sf::SharedPointer<nnt::testsf::IAllFunctionTests> AllFunctionTestsImpl::GetNullObject() NN_NOEXCEPT
{
    return nullptr;
}

void AllFunctionTestsImpl::GetNullObject2(nn::sf::Out<nn::sf::SharedPointer<nnt::testsf::IAllFunctionTests>> pOut) NN_NOEXCEPT
{
    *pOut = nullptr;
}

nn::Result AllFunctionTestsImpl::CauseError(const nn::sf::OutBuffer&, const nn::sf::OutBuffer&, const nn::sf::InBuffer&, const nn::sf::InBuffer&) NN_NOEXCEPT
{
    return ResultSfTestError();
}

int AllFunctionTestsImpl::EchoIntInherited(int x) NN_NOEXCEPT
{
    return x;
}

nn::Result AllFunctionTestsImpl::CheckAruid(nn::Bit64) NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

nn::Result AllFunctionTestsImpl::CheckAruid2(nn::applet::AppletResourceUserId) NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

std::uint32_t AllFunctionTestsImpl::GetInlineContextTest() NN_NOEXCEPT
{
    return nn::sf::cmif::GetInlineContext();
}

std::uint8_t AllFunctionTestsImpl::GetFsInlineContextTest() NN_NOEXCEPT
{
    return nn::sf::GetFsInlineContext();
}

namespace {

typedef nn::sf::ObjectFactory<
    nn::sf::impl::ExpHeapAllocator::Policy
> MyFactory;

class MyAllocator
{
public:

    std::aligned_storage<1024 * 1024>::type buffer;
    nn::sf::impl::ExpHeapAllocator allocator;

    MyAllocator()
    {
        allocator.Attach(nn::lmem::CreateExpHeap(&buffer, sizeof(buffer), nn::lmem::CreationOption_NoOption));
    }

} g_MyAllocator;

}

nn::sf::SharedPointer<IAllFunctionTests> CreateAllFunctionTests(int n) NN_NOEXCEPT
{
    return MyFactory::CreateSharedEmplaced<IAllFunctionTests, AllFunctionTestsImpl>(&g_MyAllocator.allocator, &g_MyAllocator.allocator, n);
}

}}
