﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using Nintendo.ServiceFramework.Applet;

namespace nn.applet
{
    [ExternalStruct(8, 8)]
    [CppRefPath("<nn/applet/applet_Types.h>")]
    public struct AppletResourceUserId
    {
    }
}

namespace nnt.testsf
{
    internal static class PathInfo
    {
        public const string Prefix = "\"";
        public const string Postfix = "\"";
        public const string Root = @"";
        public const string AddParameterPath = Prefix + Root + @"testSf_AddParameter.h" + Postfix;
        public const string StructsPath = Prefix + Root + @"testSf_Structs.h" + Postfix;
        public const string IAllFunctionTestsPath = Prefix + Root + @"testSf_IAllFunctionTests.sfdl.h" + Postfix;
        public const string IMultiTestsPath = Prefix + Root + @"testSf_IMultiTests.h" + Postfix;
        public const string IInheritancePath = Prefix + Root + @"testSf_IInheritance.h" + Postfix;
        public const string IBlockingMapPath = Prefix + Root + @"testSf_IBlockingMap.h" + Postfix;
        public const string IDomainTests = Prefix + Root + @"testSf_IDomainTests.h" + Postfix;
        public const string IHipcMapTransferAttributeTests = Prefix + Root + @"testsf_IHipcMapTransferAttributeTests.h" + Postfix;
    }

    [CppRefPath(PathInfo.AddParameterPath)]
    public struct AddParameter
    {
        public std.int32_t a;
        public std.int32_t b;
    }

    [CppRefPath(PathInfo.StructsPath)]
    public struct Struct1
    {
        public AddParameter addParameter;
        public char_t c;
        public char16_t c16;
        public char32_t c32;
        public std.int8_t i8;
        public std.int16_t i16;
        public std.int32_t i32;
        public std.int64_t i64;
        public bool b;
    }

    [CppRefPath(PathInfo.StructsPath)]
    public struct Struct2
    {
        // Struct1 のフィールド順序を変えたもの
        public char16_t c16;
        public std.int64_t i64;
        public std.int16_t i16;
        public AddParameter addParameter;
        public std.int32_t i32;
        public bool b;
        public char32_t c32;
        public std.int8_t i8;
        public char_t c;
    }

    [CppRefPath(PathInfo.IAllFunctionTestsPath)]
    public interface IAllFunctionTestsBase0 : IServiceObject
    {
        [MethodId(0)]
        int_t EchoInt(int_t x);
        [MethodId(1)]
        Result StoreIntWithResult(int_t x);
        [MethodId(2)]
        void StoreInt(int_t x);
        [MethodId(3)]
        int_t LoadInt();
        [MethodId(4)]
        void FlipBits(nn.sf.OutBuffer outBuffer, nn.sf.InBuffer inBuffer);
    }

    [CppRefPath(PathInfo.IAllFunctionTestsPath)]
    public interface IAllFunctionTestsBase : IAllFunctionTestsBase0
    {
        [MethodId(5)]
        std.int32_t Add(AddParameter p);
        [MethodId(6)]
        std.int32_t SumAndSubBytes(nn.sf.OutBuffer outSum, nn.sf.OutBuffer outSub, nn.sf.InBuffer inBuffer1, nn.sf.InBuffer inBuffer2);
        [MethodId(7)]
        void LoadIntByOut(Out<int_t> pOut);
        [MethodId(8)]
        Struct2 EchoStruct(Struct1 s);
        [MethodId(9)]
        void EchoStruct2(Out<Struct2> pOut, Struct1 s);
        [MethodId(10)]
        ITestSession OpenSession(int_t value);
        [MethodId(11)]
        void OpenSession2(Out<ITestSession> pOut, int_t value);
        [MethodId(12)]
        int_t GetSessionCount();
        [MethodId(14)]
        void GetNativeHandle2(Out<NativeHandle> pOut);
        [MethodId(15)]
        void MoveNativeHandle([MoveHandle] Out<NativeHandle> pOut);
        [MethodId(16)]
        void InNativeHandle(NativeHandle e);
        [MethodId(17)]
        void MoveInNativeHandle([MoveHandle] NativeHandle e);
        [MethodId(18)]
        void SetClientProcessId([ProcessId] nn.Bit64 pid);
        [MethodId(19)]
        void GetClientProcessId(nn.sf.Out<nn.Bit64> pOut);
        [MethodId(20)]
        void SquareArrayElement(nn.sf.OutArray<int32_t> dst, nn.sf.InArray<int32_t> src);
        [MethodId(21)]
        void EchoStruct3([LargeData] Out<Struct2> pOut, [LargeData] Struct1 s);
        [MethodId(22)]
        void MoveNativeHandle2([MoveHandle] Out<NativeHandle> pOut);
        [MethodId(23)]
        bool EchoBool(bool x);
        [MethodId(24)]
        uint16_t EchoUInt16(uint16_t x);
        [MethodId(25)]
        uint64_t EchoUInt64(uint64_t x);
        [MethodId(26)]
        std.int32_t SumAndSubBytes2(
            [BufferTransferMode(BufferTransferMode.PointerCopy)] nn.sf.OutBuffer outSum,
            [BufferTransferMode(BufferTransferMode.MapAlias)] nn.sf.OutBuffer outSub,
            [BufferTransferMode(BufferTransferMode.PointerCopy)] nn.sf.InBuffer inBuffer1,
            [BufferTransferMode(BufferTransferMode.MapAlias)] nn.sf.InBuffer inBuffer2);
        [MethodId(27)]
        void SquareArrayElement2(
            [BufferTransferMode(BufferTransferMode.MapAlias)] nn.sf.OutArray<int32_t> dst,
            [BufferTransferMode(BufferTransferMode.MapAlias)] nn.sf.InArray<int32_t> src);
        [MethodId(28)]
        void EchoStruct4(
            [LargeData][BufferTransferMode(BufferTransferMode.PointerCopy)] Out<Struct2> pOut,
            [LargeData][BufferTransferMode(BufferTransferMode.MapAlias)] Struct1 s);
        [MethodId(29)]
        Result DeferProcess();
        [MethodId(30)]
        IAllFunctionTests GetNullObject();
        [MethodId(31)]
        void GetNullObject2(Out<IAllFunctionTests> pOut);
        [MethodId(32)]
        Result CauseError(
            [BufferTransferMode(BufferTransferMode.PointerCopy)] nn.sf.OutBuffer outSum,
            [BufferTransferMode(BufferTransferMode.MapAlias)] nn.sf.OutBuffer outSub,
            [BufferTransferMode(BufferTransferMode.PointerCopy)] nn.sf.InBuffer inBuffer1,
            [BufferTransferMode(BufferTransferMode.MapAlias)] nn.sf.InBuffer inBuffer2);
        [MethodId(33)]
        std.int32_t SumAndSubBytes3(
            [BufferTransferMode(BufferTransferMode.AutoSelect)] nn.sf.OutBuffer outSum,
            [AutoSelectBuffer] nn.sf.OutBuffer outSub,
            [AutoSelectBuffer] nn.sf.InBuffer inBuffer1,
            [BufferTransferMode(BufferTransferMode.AutoSelect)] nn.sf.InBuffer inBuffer2);
        [MethodId(34)]
        std.int32_t SumAndSubBytes4(
            [BufferTransferMode(BufferTransferMode.PointerCopy)] nn.sf.OutBuffer outSum,
            [AutoSelectBuffer] nn.sf.OutBuffer outSub,
            [AutoSelectBuffer] nn.sf.InBuffer inBuffer1,
            [BufferTransferMode(BufferTransferMode.MapAlias)] nn.sf.InBuffer inBuffer2);
        [MethodId(35)]
        Result CheckAruid([CheckAppletResourceUserId] nn.Bit64 aruid);
        [MethodId(36)]
        Result CheckAruid2([CheckAppletResourceUserId] nn.applet.AppletResourceUserId aruid);
        [MethodId(37)]
        void OpenSessionChar(Out<ITestSession> pOut, Out<char_t> pCharOut, char_t x);
        [MethodId(38)]
        std.uint32_t GetInlineContextTest();
        [MethodId(39)]
        std.uint8_t GetFsInlineContextTest();
    }

    [CppRefPath(PathInfo.IAllFunctionTestsPath)]
    public interface IAllFunctionTests : IAllFunctionTestsBase
    {
        [MethodId(3000)]
        int_t EchoIntInherited(int_t x);
    }

    [CppRefPath(PathInfo.IAllFunctionTestsPath)]
    public interface ITestSession : IServiceObject
    {
        [MethodId(0)]
        int_t GetValue();
    }

    [CppRefPath(PathInfo.IMultiTestsPath)]
    public interface IMulti1 : IServiceObject
    {
        [MethodId(0)]
        int_t Add(int_t x, int_t y);

        [MethodId(1)]
        int_t Sub(int_t x, int_t y);
    }

    [CppRefPath(PathInfo.IMultiTestsPath)]
    public interface IMulti2 : IServiceObject
    {
        [MethodId(0)]
        int_t Sub(int_t x, int_t y);

        [MethodId(1)]
        int_t Multiply(int_t x, int_t y);
    }

    [CppRefPath(PathInfo.IMultiTestsPath)]
    public interface IMulti3 : IServiceObject
    {
        [MethodId(0)]
        int_t Multiply(int_t x, int_t y);

        [MethodId(1)]
        int_t Add(int_t x, int_t y);
    }

    [CppRefPath(PathInfo.IMultiTestsPath)]
    public interface IMultiAll : IServiceObject
    {
        [MethodId(0)]
        int_t Add(int_t x, int_t y);

        [MethodId(1)]
        int_t Sub(int_t x, int_t y);

        [MethodId(2)]
        int_t Multiply(int_t x, int_t y);
    }

    [CppRefPath(PathInfo.IInheritancePath)]
    public interface IInheritanceBase1 : IServiceObject
    {
        [MethodId(1)]
        int_t Get1();
    }
    [CppRefPath(PathInfo.IInheritancePath)]
    public interface IInheritanceBase2 : IInheritanceBase1
    {
        [MethodId(2)]
        int_t Get2();
    }
    [CppRefPath(PathInfo.IInheritancePath)]
    public interface IInheritance : IInheritanceBase2
    {
        [MethodId(3)]
        int_t Get3();
    }

    [CppRefPath(PathInfo.IBlockingMapPath)]
    public interface IBlockingMap : IServiceObject
    {
        [MethodId(0)]
        Result SetKeyValue(int32_t key, int32_t value);

        [MethodId(1)]
        Result TryGetValue(Out<bool> pOutValid, Out<int32_t> pOutValue, int32_t key);

        [MethodId(2)]
        Result GetValue(Out<int32_t> pOut, int32_t key);

        [MethodId(3)]
        uint32_t TestContext(uint32_t n);
    }

    [CppRefPath(PathInfo.IDomainTests)]
    public interface IDomainTestObject : IServiceObject
    {
        [MethodId(0)]
        Result Open(Out<IDomainTestObject> pOut);

        [MethodId(1)]
        Result AddValue(int64_t n);

        [MethodId(2)]
        Result GetValue(Out<int64_t> pOut);

        [MethodId(3)]
        Result AddValueWith(IDomainTestObject target, int64_t n);

        [MethodId(4)]
        Result AddCharValueWith(IDomainTestObject target, int8_t n);
    }

    [CppRefPath(PathInfo.IHipcMapTransferAttributeTests)]
    public interface IHipcMapTransferAttributedObject : IServiceObject
    {
        [MethodId(0)]
        Result Secure([MapTransferSecurity(MapTransferSecurity.Secure)] nn.sf.InBuffer inBuffer, [MapTransferSecurity(MapTransferSecurity.Secure)] nn.sf.OutBuffer outBuffer);

        [MethodId(1)]
        Result NonSecure([MapTransferSecurity(MapTransferSecurity.NonSecure)] nn.sf.InBuffer inBuffer, [MapTransferSecurity(MapTransferSecurity.NonSecure)] nn.sf.OutBuffer outBuffer);

        [MethodId(2)]
        Result NonDevice([MapTransferSecurity(MapTransferSecurity.NonDevice)] nn.sf.InBuffer inBuffer, [MapTransferSecurity(MapTransferSecurity.NonDevice)] nn.sf.OutBuffer outBuffer);
    }

    [CppRefPath(PathInfo.IHipcMapTransferAttributeTests)]
    public interface IWrongHipcMapTransferAttributedObject : IServiceObject
    {
        [MethodId(0)]
        Result Secure([MapTransferSecurity(MapTransferSecurity.NonSecure)] nn.sf.InBuffer inBuffer, [MapTransferSecurity(MapTransferSecurity.Secure)] nn.sf.OutBuffer outBuffer);

        [MethodId(1)]
        Result NonSecure([MapTransferSecurity(MapTransferSecurity.NonDevice)] nn.sf.InBuffer inBuffer, [MapTransferSecurity(MapTransferSecurity.NonSecure)] nn.sf.OutBuffer outBuffer);

        [MethodId(2)]
        Result NonDevice([MapTransferSecurity(MapTransferSecurity.Secure)] nn.sf.InBuffer inBuffer, [MapTransferSecurity(MapTransferSecurity.NonDevice)] nn.sf.OutBuffer outBuffer);
    }
}
