﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/settings/system/settings_Tv.h>
#include <nnt/nntest.h>

namespace {

//!< テスト用 TV 設定 A
const ::nn::settings::system::TvSettings TvSettingsA = {
    { { 0x0000000A } },
    static_cast<int32_t>(::nn::settings::system::TvResolution_1080p),
    static_cast<int32_t>(::nn::settings::system::HdmiContentType_Graphics),
    static_cast<int32_t>(::nn::settings::system::RgbRange_Full),
    static_cast<int32_t>(::nn::settings::system::CmuMode_HighContrast),
    5,
    0.5f,
    0.0f,
};

//!< テスト用 TV 設定 B
const ::nn::settings::system::TvSettings TvSettingsB = {
    { { 0x00000005 } },
    static_cast<int32_t>(::nn::settings::system::TvResolution_480p),
    static_cast<int32_t>(::nn::settings::system::HdmiContentType_Game),
    static_cast<int32_t>(::nn::settings::system::RgbRange_Limited),
    static_cast<int32_t>(::nn::settings::system::CmuMode_GrayScale),
    10,
    3.0f,
    0.1f,
};

} // namespace

//!< TV 設定を取得可能か
TEST(TvSuite, TvSettingsTest1)
{
    ::nn::settings::system::TvSettings settings = {};

    ::nn::settings::system::GetTvSettings(&settings);
}

//!< TV 設定を設定可能か
TEST(TvSuite, TvSettingsTest2)
{
    ::nn::settings::system::SetTvSettings(TvSettingsA);

    ::nn::settings::system::TvSettings settings = {};

    ::nn::settings::system::SetTvSettings(TvSettingsB);

    ::nn::settings::system::GetTvSettings(&settings);

    EXPECT_EQ(TvSettingsB.flags, settings.flags);

    EXPECT_EQ(TvSettingsB.tvResolution, settings.tvResolution);

    EXPECT_EQ(TvSettingsB.hdmiContentType, settings.hdmiContentType);

    EXPECT_EQ(TvSettingsB.rgbRange, settings.rgbRange);

    EXPECT_EQ(TvSettingsB.cmuMode, settings.cmuMode);

    EXPECT_EQ(TvSettingsB.tvUnderscan, settings.tvUnderscan);

    EXPECT_FLOAT_EQ(TvSettingsB.tvGamma, settings.tvGamma);

    EXPECT_FLOAT_EQ(TvSettingsB.contrastRatio, settings.contrastRatio);

    ::nn::settings::system::SetTvSettings(TvSettingsA);

    ::nn::settings::system::GetTvSettings(&settings);

    EXPECT_EQ(TvSettingsA.flags, settings.flags);

    EXPECT_EQ(TvSettingsA.tvResolution, settings.tvResolution);

    EXPECT_EQ(TvSettingsA.hdmiContentType, settings.hdmiContentType);

    EXPECT_EQ(TvSettingsA.rgbRange, settings.rgbRange);

    EXPECT_EQ(TvSettingsA.cmuMode, settings.cmuMode);

    EXPECT_EQ(TvSettingsA.tvUnderscan, settings.tvUnderscan);

    EXPECT_FLOAT_EQ(TvSettingsA.tvGamma, settings.tvGamma);

    EXPECT_FLOAT_EQ(TvSettingsA.contrastRatio, settings.contrastRatio);
}

//!< EDID を取得可能か
TEST(TvSuite, EdidTest1)
{
    ::nn::settings::system::Edid edid = {};

    ::nn::settings::system::GetEdid(&edid);
}

//!< EDID を設定可能か
TEST(TvSuite, EdidTest2)
{
    ::nn::settings::system::Edid edid = {};

    auto buffer = reinterpret_cast<char*>(&edid);

    auto bufferSize = sizeof(::nn::settings::system::Edid);

    for (size_t i = 0; i < bufferSize; ++i)
    {
        buffer[i] = '0';
    }

    ::nn::settings::system::SetEdid(edid);

    for (size_t i = 0; i < bufferSize; ++i)
    {
        buffer[i] = static_cast<char>('A' + (i % 26));
    }

    ::nn::settings::system::SetEdid(edid);

    for (size_t i = 0; i < bufferSize; ++i)
    {
        buffer[i] = '0';
    }

    ::nn::settings::system::GetEdid(&edid);

    for (size_t i = 0; i < bufferSize; ++i)
    {
        EXPECT_EQ(static_cast<char>('A' + (i % 26)), buffer[i]);
    }
}
