﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ncm/ncm_ProgramId.h>
#include <nn/settings/factory/settings_Boot.h>
#include <nn/settings/system/settings_Boot.h>
#include <nnt/nntest.h>

namespace {

//!< テスト用 ProgramId A
const ::nn::ncm::ProgramId ProgramIdA = { 0xDEAD };

//!< テスト用 ProgramId B
const ::nn::ncm::ProgramId ProgramIdB = { 0xCAFE };

//!< テスト用 ProgramId C
const ::nn::ncm::ProgramId ProgramIdC = { 0xFEED };

//!< テスト用 ProgramId D
const ::nn::ncm::ProgramId ProgramIdD = { 0xBEAF };

} // namespace

//!< 初回ブートするシステムアプレットの ProgramId を取得可能か
TEST(BootSuite, InitialSystemAppletProgramIdTest1)
{
    ::nn::settings::system::GetInitialSystemAppletProgramId();
}

//!< 初回ブートするシステムアプレットの ProgramId を設定可能か
TEST(BootSuite, InitialSystemAppletProgramIdTest2)
{
    ::nn::settings::factory::SetInitialSystemAppletProgramId(ProgramIdA);

    EXPECT_EQ(ProgramIdA,
              ::nn::settings::system::GetInitialSystemAppletProgramId());

    ::nn::settings::factory::SetInitialSystemAppletProgramId(ProgramIdB);

    EXPECT_EQ(ProgramIdB,
              ::nn::settings::system::GetInitialSystemAppletProgramId());
}

//!< 初回ブートするオーバーレイ表示の ProgramId を取得可能か
TEST(BootSuite, OverlayDispProgramIdTest1)
{
    ::nn::settings::system::GetOverlayDispProgramId();
}

//!< 初回ブートするオーバーレイ表示の ProgramId を設定可能か
TEST(BootSuite, OverlayDispProgramIdTest2)
{
    ::nn::settings::factory::SetOverlayDispProgramId(ProgramIdC);

    EXPECT_EQ(ProgramIdC,
              ::nn::settings::system::GetOverlayDispProgramId());

    ::nn::settings::factory::SetOverlayDispProgramId(ProgramIdD);

    EXPECT_EQ(ProgramIdD,
              ::nn::settings::system::GetOverlayDispProgramId());
}

//!< 修理中か否かを取得可能か
TEST(BootSuite, InRepairTest1)
{
    ::nn::settings::system::IsInRepairProcess();
}

//!< 修理中か否かを設定可能か
TEST(BootSuite, InRepairTest2)
{
    auto value = ::nn::settings::system::IsInRepairProcess();

    ::nn::settings::system::SetInRepairProcessEnabled(true);

    EXPECT_TRUE(::nn::settings::system::IsInRepairProcess());

    ::nn::settings::system::SetInRepairProcessEnabled(false);

    EXPECT_FALSE(::nn::settings::system::IsInRepairProcess());

    ::nn::settings::system::SetInRepairProcessEnabled(true);

    EXPECT_TRUE(::nn::settings::system::IsInRepairProcess());

    ::nn::settings::system::SetInRepairProcessEnabled(value);
}

//!< 時計補正が必要か否かを取得可能か
TEST(BootSuite, RequiresRunRepairTimeReviser1)
{
    ::nn::settings::system::RequiresRunRepairTimeReviser();
}

//!< 時計補正が必要か否かを設定可能か
TEST(BootSuite, RequiresRunRepairTimeReviser2)
{
    auto value = ::nn::settings::system::RequiresRunRepairTimeReviser();

    ::nn::settings::system::SetRequiresRunRepairTimeReviser(true);

    EXPECT_TRUE(::nn::settings::system::RequiresRunRepairTimeReviser());

    ::nn::settings::system::SetRequiresRunRepairTimeReviser(false);

    EXPECT_FALSE(::nn::settings::system::RequiresRunRepairTimeReviser());

    ::nn::settings::system::SetRequiresRunRepairTimeReviser(true);

    EXPECT_TRUE(::nn::settings::system::RequiresRunRepairTimeReviser());

    ::nn::settings::system::SetRequiresRunRepairTimeReviser(value);
}
