﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>

namespace nnt { namespace settings { namespace fwdbg {

//!< テスト環境を初期化します。
void InitializeTestEnvironment() NN_NOEXCEPT;

//!< 設定を初期化します。
void InitializeSettings() NN_NOEXCEPT;

//!< 設定を作成します。
void CreateSettings(const char* name) NN_NOEXCEPT;

//!< 設定項目を作成します。
void CreateSettingsItem(const char* name,
                        const char* key,
                        const void* value,
                        size_t size) NN_NOEXCEPT;

}}} // namaspace nnt::settings::fwdbg
