﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/nn_Macro.h>
#include <nn/os.h>
#include <nnt/nntest.h>
#include <nnt/base/testBase_Exit.h>
#include <nnt/nnt_Argument.h>

#include "testSettings_Utility.h"

class FileSystemEnvironment final : public ::testing::Environment
{
public:
    virtual void SetUp() NN_OVERRIDE;
};

extern "C" void nnMain()
{
    int argc = ::nnt::GetHostArgc();

    char** argv = ::nnt::GetHostArgv();

    NN_LOG("Running nnMain() from testSettings_Main.cpp\n");

    ::testing::InitGoogleTest(&argc, argv);

    ::testing::AddGlobalTestEnvironment(new FileSystemEnvironment);

    int result = RUN_ALL_TESTS();

    ::nnt::Exit(result);
}

void FileSystemEnvironment::SetUp()
{
    ::nnt::settings::fwdbg::InitializeTestEnvironment();
}
