﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/settings/fwdbg/settings_SettingsCommon.h>
#include <nn/settings/fwdbg/settings_SettingsSetterApi.h>
#include <nnt/nntest.h>

#include "testSettings_Utility.h"

//!< デバッグモードが有効か否かを表す値を取得できるか
TEST(DebugModeSuite, DebugModeTest1)
{
    const char* const name = "settings_debug";
    const char* const key = "is_debug_mode_enabled";

    bool value = false;
    const size_t size = sizeof(value);

    // テスト用の設定を初期化
    ::nnt::settings::fwdbg::InitializeSettings();

    // 設定値が存在しなければ true
    EXPECT_TRUE(::nn::settings::fwdbg::IsDebugModeEnabled());

    // テスト用の設定を作成
    ::nnt::settings::fwdbg::CreateSettings(name);
    ::nnt::settings::fwdbg::CreateSettingsItem(name, key, &value, size);

    // 設定値が false なので false
    EXPECT_FALSE(::nn::settings::fwdbg::IsDebugModeEnabled());

    value = true;
    ::nn::settings::fwdbg::SetSettingsItemValue(name, key, &value, size);

    // 設定値が true なので true
    EXPECT_TRUE(::nn::settings::fwdbg::IsDebugModeEnabled());
}
