﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstring>

#include <nn/nn_Abort.h>
#include <nn/nn_Log.h>
#include <nn/gc/detail/gc_Util.h>
#include <nn/gc/detail/gc_Log.h>
#include "Types.h"

// *** マクロ
// NOTE: 仮定義
#define SC_DETAIL_LOG2_ENABLE
#define SC_DETAIL_ERR_LOG_ENABLE
#define SC_DETAIL_FILE_LOG_ENABLE
////
#define SC_LOG_ENABLE
#define SC_DETAIL_LOG_ENABLE
//#define SC_DETAIL_DEBUG_LOG_ENABLE
//#define SC_DETAIL_IO_LOG_ENABLE
//#define SC_DETAIL_CRYPTO_LOG_ENABLE
//#define SC_DEBUG_MEMDUMP_ENABLE
// #define SC_ENABLE_DEBUG_TEST_PRINT

// 後退テスト用
// #define SC_LOG_ALWAYS_FULL


const int MAX_FILE_PATH_SIZE = 256;


// 共通マクロ
#define _NN_SC_DETAIL_LOG(fmt, ...)   GC_NN_SDK_LOG(fmt, ##__VA_ARGS__)
#define _NN_SC_DETAIL_DEBUG_LOG(fmt, ...)   GC_NN_SDK_LOG("[sc] %s():%d - %s / " fmt, __FUNCTION__, __LINE__, __FILE__, ##__VA_ARGS__)

// 出力マクロ（define により有効・無効を切り替え）
#ifdef SC_LOG_ENABLE
#define NN_SC_LOG(...)   _NN_SC_DETAIL_LOG( "[sc] " __VA_ARGS__)
#define NN_SC_LOG_S(...)   _NN_SC_DETAIL_LOG( __VA_ARGS__)
#else
#define NN_SC_LOG(...)   static_cast<void>(0)
#define NN_SC_LOG_S(...)   static_cast<void>(0)
#endif

#ifdef SC_DETAIL_LOG_ENABLE
#define NN_SC_DETAIL_LOG(...)   _NN_SC_DETAIL_LOG( "[sc] " __VA_ARGS__)
#define NN_SC_DETAIL_LOG_S(...)   _NN_SC_DETAIL_LOG( __VA_ARGS__)
#else
#define NN_SC_DETAIL_LOG(...)   static_cast<void>(0)
#define NN_SC_DETAIL_LOG_S(...)   static_cast<void>(0)
#endif



#ifdef SC_DETAIL_LOG2_ENABLE
#define NN_SC_DETAIL_LOG2(...)   _NN_SC_DETAIL_LOG( "[sc] " __VA_ARGS__)
#else
#define NN_SC_DETAIL_LOG2(...)   static_cast<void>(0)
#endif

#ifdef SC_DETAIL_DEBUG_LOG_ENABLE
#define NN_SC_DETAIL_DEBUG_LOG(...)   _NN_SC_DETAIL_DEBUG_LOG( __VA_ARGS__ )
#else
#define NN_SC_DETAIL_DEBUG_LOG(...)   static_cast<void>(0)
#endif

#ifdef SC_DETAIL_ERR_LOG_ENABLE
#define NN_SC_DETAIL_ERR_LOG(...)   _NN_SC_DETAIL_LOG("[sc] Error: " __VA_ARGS__)
#else
#define NN_SC_DETAIL_ERR_LOG(...)   static_cast<void>(0)
#endif

#ifdef SC_DETAIL_FILE_LOG_ENABLE
#define NN_SC_DETAIL_FILE_LOG(...)   _NN_SC_DETAIL_LOG("[sc](file) " __VA_ARGS__)
#else
#define NN_SC_DETAIL_FILE_LOG(...)   static_cast<void>(0)
#endif

#ifdef SC_DETAIL_IO_LOG_ENABLE
#define NN_SC_DETAIL_IO_LOG(...)   _NN_SC_DETAIL_LOG("[sc](IO) " __VA_ARGS__)
#else
#define NN_SC_DETAIL_IO_LOG(...)   static_cast<void>(0)
#endif

#ifdef SC_DETAIL_CRYPTO_LOG_ENABLE
#define NN_SC_DETAIL_CRYPTO_LOG(...)   _NN_SC_DETAIL_LOG("[sc](Crypto) " __VA_ARGS__)
#else
#define NN_SC_DETAIL_CRYPTO_LOG(...)   static_cast<void>(0)
#endif

#ifdef SC_DEBUG_MEMDUMP_ENABLE
#define NN_SC_DEBUG_MEMDUMP(buffer, bufferLength, ...)   _NN_SC_DETAIL_LOG("[sc](dump) " __VA_ARGS__); \
    PrintDebugArray(buffer, bufferLength)
#define NN_SC_DEBUG_MEMDUMP_QB(queueBuffer, ...)   _NN_SC_DETAIL_LOG("[sc](dump) " __VA_ARGS__); \
    PrintDebugArray(queueBuffer.dataBuffer, queueBuffer.length)
#else
#define NN_SC_DEBUG_MEMDUMP(...)   static_cast<void>(0)
#define NN_SC_DEBUG_MEMDUMP_QB(...)   static_cast<void>(0)
#endif

void PrintDebugArray(const char* buffer, const size_t bufferLength);
void GetOperationBuffer(char* pOutBuffer, Operation operationId);
