﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "Types.h"

class OperationData;
class StorageInterface;


class Time
{
public:
    Time() : m_StartTime(0), m_EndTime(0) {}
    ~Time() {}

    void Start()
    {
        m_StartTime = nn::os::GetSystemTick();
    }

    int64_t GetElapsedTime()
    {
        m_EndTime = nn::os::GetSystemTick();
        return (m_EndTime - m_StartTime).ToTimeSpan().GetMicroSeconds();
    }

private:
    nn::os::Tick m_StartTime;
    nn::os::Tick m_EndTime;
};


class OperationInterpreter
{
public:
    Time logTimer;

private:
    static const int maxLoopNestCount = 64;
    int m_LoopCountStack[maxLoopNestCount];
    int m_LoopCountStackCurrentIndex;

public:
    static OperationInterpreter &GetInstance()
    {
        static OperationInterpreter m_Instance;
        return m_Instance;
    }

    // オペレーションデータのリストを辿りながら処理
    OperationData* InterpretOperationDataList(OperationData* pOperation);

    void PrintLoopIndex();
    bool IsInLoop()
    {
        return m_LoopCountStackCurrentIndex >= 0;
    }

private:
    OperationInterpreter();
    void PrintErrorInfos();
    // オペレーションデータの処理
    OperationData* InterpretOperationData(OperationData* pOperation);
};
