﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <cstdio>
#include <string>
#include <cstring>
#include <cstdlib>
#include <nn/nn_Common.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/init.h>
#include <nn/os.h>

#include "FileAccessor.h"

const u32 MaxDirectoryCount = 256;

class FileManager
{
private:
    FileManager()
    {
        m_FileNum = 0;
        m_IsInitialized = false;
    }
    int64_t m_FileNum;
    bool m_IsInitialized;
    nn::fs::DirectoryEntry m_DirectoryEntryList[MaxDirectoryCount];
public:
    static FileManager* GetInstance()
    {
        static FileManager fileManager;
        return &fileManager;
    }
    void Mount()
    {
        // マウント
        FileAccessor::defaultMountPath.UpdatePath("seq", "C:/ref/hostIO/StorageChecker");
        FileAccessor& fileAccessor = FileAccessor::GetInstance();
        fileAccessor.Mount();
    }
    void Unmount()
    {
        FileAccessor& fileAccessor = FileAccessor::GetInstance();
        fileAccessor.Unmount();
    }
    void Initialize()
    {
        // ファイルリスト取得
        FileAccessor& fileAccessor = FileAccessor::GetInstance();
        MountPath& path = FileAccessor::defaultMountPath;
        fileAccessor.GetFileList(m_DirectoryEntryList, &m_FileNum, MaxDirectoryCount, path.GetMountPath().c_str());
        // "seq.bin"以外を m_DirectoryEntryList から削除
        size_t listNum = 0;
        for(int64_t i = 0; i < m_FileNum; i++)
        {
            if(strstr(m_DirectoryEntryList[i].name, ".seq.bin") != NULL)
            {
                m_DirectoryEntryList[listNum++] = m_DirectoryEntryList[i];
            }
        }
        m_FileNum = listNum;
        m_IsInitialized = true;
    }
    u32 GetFileName(char* pOutBuffer, size_t outBufferSize, int64_t fileIndex)
    {
        size_t nameLength = strlen(m_DirectoryEntryList[fileIndex].name) + 1;
        if(outBufferSize < nameLength)
        {
            NN_LOG("Size Over!\n");
            return 0;
        }
        strncpy(pOutBuffer, m_DirectoryEntryList[fileIndex].name, nameLength);
        return nameLength;
    }
    size_t ReadFile(u8* pOutBuffer, size_t outBufferSize, int64_t fileIndex)
    {
        FileAccessor& fileAccessor = FileAccessor::GetInstance();
        MountPath& path = FileAccessor::defaultMountPath;
        size_t readDataSize = 0;
        fileAccessor.Read(pOutBuffer, &readDataSize, outBufferSize, path.GetMountPath(m_DirectoryEntryList[fileIndex].name).c_str());
        return readDataSize;
    }
    bool IsInitialized()
    {
        return m_IsInitialized;
    }
    int64_t GetFileNum()
    {
        return m_FileNum;
    }
};
