﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>
#include <cstring>
#include <cstdlib>
#include <nn/nn_Common.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include "Types.h"
#include "DataStructure.h"
#include <nn/os.h>
#include <nn/gc/detail/gc_Util.h>


const size_t ScriptNameSize = 64;
const size_t LogLineMaxNum = 15;
const size_t LogMaxLength  = 128;

class DisplayData
{
private:
    DisplayData()
    {
        memset(scriptName, 0xff, sizeof(scriptName));
        startSectorIndex = 0;
        totalSectorNum = 0;
        currentSecoterIndex = 0;
        chunkSize = 0;
        loopNum = 0;
        lineIndex = 0;
        isError = false;
        isSetting = false;
    }
    char scriptName[ScriptNameSize];
    size_t m_LogSizeList[LogLineMaxNum];
    nn::gc::detail::CharRingBuffer m_RingBuffer;

public:
    static DisplayData* GetInstance()
    {
        static DisplayData displayData;
        return &displayData;
    }

    void SetBuffer(char* dataBuffer, unsigned int dataBufferLength)
    {
        m_RingBuffer.SetBuffer(dataBuffer, dataBufferLength);
    }

    void Reset()
    {
        memset(scriptName, 0xff, sizeof(scriptName));
        startSectorIndex = 0;
        totalSectorNum = 0;
        currentSecoterIndex = 0;
        chunkSize = 0;
        loopNum = 0;
        lineIndex = 0;
        isError = false;
        isSetting = false;
    }

    void SetScriptName(char* pScriptName, size_t scriptNameSize)
    {
        strncpy(scriptName, pScriptName, scriptNameSize);
    }
    void GetScriptName(char* pOutScriptName)
    {
        strncpy(pOutScriptName, scriptName, strlen(scriptName) + 1);
    }

    /** ドライバのログを画面表示用 FIFO バッファに詰める **/
    void SetLog(char* pLog, size_t logLength, size_t index)
    {
        m_RingBuffer.Enqueue(pLog, logLength);
        m_RingBuffer.AddNullByteToLast();
    }
    void PutLogFifo()
    {
        for(size_t i = 0; i < LogLineMaxNum - 1; i++)
        {
            m_LogSizeList[i] = m_LogSizeList[i + 1];
        }
    }
    void GetLog(char* buffer, size_t bufferLength, size_t index)
    {
        while(isSetting)
        {
            nn::os::SleepThread(nn::TimeSpan::FromMicroSeconds(100));
        }
        m_RingBuffer.GetLine(buffer, bufferLength, index);
    }

    OperationData operation;
    u32 startSectorIndex;
    u32 totalSectorNum;
    u32 currentSecoterIndex;
    u32 chunkSize;
    u32 loopNum;
    u32 lineIndex;
    bool isError;
    nn::Result result;
    nn::os::Tick errorTick;
    bool isSetting;
    size_t bufferSizeForGameCardCommand;
};
