﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>
#include <cstdlib>
#include "DataStructure.h"
#include "Util.h"
#include <nn/nn_Log.h>

OperationDataManager::OperationDataManager(u8* workBuffer, u32 workBufferSize)
{
    // バッファを登録
    rawDataBuffer = workBuffer;
    rawDataBufferSize = workBufferSize;

    // データの初期化
    operationDataArray = NULL;
    this->ClearBuffer();
}

OperationDataManager::~OperationDataManager()
{
    this->ClearBuffer();
}

void OperationDataManager::ClearBuffer()
{
    if( operationDataArray != NULL )
    {
        delete[] operationDataArray;
    }
    // データの初期化
    operationDataArray = NULL;
    operationDataArrayCount = 0;
}

void OperationDataManager::ParseDataStructure()
{
    this->ClearBuffer();

    // ヘッダのパース
    std::memcpy(reinterpret_cast<u8*>(&dataHeader), rawDataBuffer, U8SIZEOF(dataHeader));

    // メモリの動的確保：最初と最後は特殊処理
    operationDataArray = new OperationData[dataHeader.operationDataEntryCount + 2];

    // オペレーションデータエントリを元とする全データパース
    for(u32 i=0; i<dataHeader.operationDataEntryCount; i++)
    {
        // オペレーションデータエントリの情報取得
        u8* targetEntryAddress = rawDataBuffer + dataHeader.operationDataEntryStartAddress + U8SIZEOF(OperationDataEntry) * i;
        OperationDataEntry* opDataEntry = reinterpret_cast<OperationDataEntry*>(targetEntryAddress);

        // 引数データの情報取得
        targetEntryAddress = rawDataBuffer + dataHeader.argumentDataEntryStartAddress + U8SIZEOF(ArgumentData::ArgumentDataEntry) * opDataEntry->argIndex;
        ArgumentData::ArgumentDataEntry* argDataEntry = reinterpret_cast<ArgumentData::ArgumentDataEntry*>(targetEntryAddress);

        // バイナリデータの情報取得
        targetEntryAddress = rawDataBuffer + dataHeader.binaryDataEntryStartAddress + U8SIZEOF(BinaryData::BinaryDataEntry) * opDataEntry->dataIndex;
        BinaryData::BinaryDataEntry* binDataEntry = reinterpret_cast<BinaryData::BinaryDataEntry*>(targetEntryAddress);

        // サイズ計算用の次のバイナリデータ情報取得
        targetEntryAddress = rawDataBuffer + dataHeader.binaryDataEntryStartAddress + U8SIZEOF(BinaryData::BinaryDataEntry) * (opDataEntry->dataIndex + 1);
        BinaryData::BinaryDataEntry* binNextDataEntry = reinterpret_cast<BinaryData::BinaryDataEntry*>(targetEntryAddress);

        // アドレスを変換しつつ、オペレーションデータ配列へ格納
        operationDataArray[i].operationId = (Operation)(opDataEntry->operationId);
        operationDataArray[i].arg.SetData(argDataEntry, TranslateArgumentDataStartAddress(argDataEntry->addressPart.offsAddress));
        operationDataArray[i].data.address = TranslateBinaryDataStartAddress(binDataEntry->offsAddress);
        operationDataArray[i].data.size = binNextDataEntry->offsAddress - binDataEntry->offsAddress;
    }

    // インデックスの格納・リンクの作成・データサイズの格納
    for(u32 i=0; i<dataHeader.operationDataEntryCount; i++)
    {
        // インデックスを格納
        operationDataArray[i].index = i;

        // リンクの作成とデータサイズの計算・格納
        const u32 next_i = (i + 1);
        if(next_i < dataHeader.operationDataEntryCount)
        {
            operationDataArray[next_i].prev = &(operationDataArray[i]);
            operationDataArray[i].next = &(operationDataArray[next_i]);
        }
    }
    // NOTE: BinaryDataEntry 列の先頭・末尾は変換ツール側で Operation からインデックス参照されないダミーデータ（サイズ0）をつけてもらうことになっている
    // （先頭のダミーデータは「データなし」の意味として使用し、末尾のダミーデータは最後の実データのサイズの正しさの保証のために挿入）
}
