﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 * @file
 * @brief   lsm6ds3 ライブラリのデータ型や定数の定義です。
 */

#include <nn/nn_Common.h>

namespace nnt {
namespace sasbus {
namespace lsm6ds3 {

/**
 * @brief       3軸をもつセンサーの値[count]を表す構造体です。
 */
struct SensorCountState
{
     int16_t x;  //!< センサーの x 軸の値
     int16_t y;  //!< センサーの y 軸の値
     int16_t z;  //!< センサーの z 軸の値
};

/**
 * @brief       6軸センサーの入力状態[count]を表す構造体です。
 */
struct SixAxisSensorCountState
{
    SensorCountState acceleration;     //!< 加速度のカウント値。
    SensorCountState angularVelocity;  //!< 角速度のカウント値。
};

/**
 * @brief       設定可能な加速度センサーの Full Scale Range の値です。
 */
enum AccelerometerFsr : uint8_t
{
    AccelerometerFsr_2G,       //!< ±2G
    AccelerometerFsr_4G,       //!< ±4G
    AccelerometerFsr_8G,       //!< ±8G
    AccelerometerFsr_16G,      //!< ±16G
};

/**
 * @brief       設定可能なジャイロセンサーの Full Scale Range の値です。
 */
enum GyroscopeFsr : uint8_t
{
    GyroscopeFsr_125dps ,   //!< ±125dps
    GyroscopeFsr_245dps ,   //!< ±245dps
    GyroscopeFsr_500dps ,   //!< ±500dps
    GyroscopeFsr_1000dps,   //!< ±1000dps
    GyroscopeFsr_2000dps,   //!< ±2000dps
};

/**
 * @brief       設定可能な加速度センサーの Output Data Rate の値です。
 */
enum AccelerometerOdr : uint8_t
{
    AccelerometerOdr_0Hz   , //!< 0Hz
    AccelerometerOdr_13Hz  , //!< 13Hz
    AccelerometerOdr_26Hz  , //!< 26Hz
    AccelerometerOdr_52Hz  , //!< 52Hz
    AccelerometerOdr_104Hz , //!< 104Hz
    AccelerometerOdr_208Hz , //!< 208Hz
    AccelerometerOdr_416Hz , //!< 416Hz
    AccelerometerOdr_833Hz , //!< 833Hz
    AccelerometerOdr_1660Hz, //!< 1660Hz
    AccelerometerOdr_3330Hz, //!< 3330Hz
    AccelerometerOdr_6660Hz, //!< 6660Hz
};

/**
 * @brief       設定可能なジャイロセンサーの Output Data Rate の値です。
 */
enum GyroscopeOdr : uint8_t
{
    GyroscopeOdr_0Hz   , //!< 0Hz
    GyroscopeOdr_13Hz  , //!< 13Hz
    GyroscopeOdr_26Hz  , //!< 26Hz
    GyroscopeOdr_52Hz  , //!< 52Hz
    GyroscopeOdr_104Hz , //!< 104Hz
    GyroscopeOdr_208Hz , //!< 208Hz
    GyroscopeOdr_416Hz , //!< 416Hz
    GyroscopeOdr_833Hz , //!< 833Hz
    GyroscopeOdr_1660Hz, //!< 1660Hz
};

} // lsm6ds3
} // sasbus
} // nnt

