﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <cstdio>
#include <cstring>
#include <cstdlib>
#include <tuple>

#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Common.h>
#include <nn/init.h>
#include <nn/os.h>
#include <nnt.h>

#include "fileutils.h"
#include "textutils.h"

#include "executils.h"

//#include "nspr.h"
//#include "prtypes.h"
#include "prinit.h"
#include "nss.h"

using namespace std;

//  External declaration of testMain used by existing NSS test code
//  so we can call it from the test framework.
extern "C" int lowhashtestMain(int argc, char **argv);

//  Pick up NSPR's snprintf to avoid conditionalizing our code
extern "C" unsigned long PR_snprintf(char *out, unsigned long outlen, const char *fmt, ...);


namespace nnt
{

namespace nss
{


TEST(LowHashTest, All)
{
    int                         testArgc;
    char                       *testArgv[MAX_ARGS];
    int                         failCount = 0;
    char                        testName[] = "lowhashtest";

    testArgc = 1;
    testArgv[0] = testName;
    failCount = lowhashtestMain(testArgc, testArgv);
    EXPECT_EQ(failCount, 0);
}

}    //  nss
}    //  nnt


extern "C" void nnMain()
{
    int                         argc = nnt::GetHostArgc();
    char                        **argv = nnt::GetHostArgv();

    //  Init the test harness, get it ready to go
    ::testing::InitGoogleTest(&argc, argv);

/*
    for (int i = 0; i < argc; i++)
    {

        if (strcmp(SIGLOHOST_OPTION, argv[i]) == 0)
        {
            //  Found the host option, grab it
            i++;
            HOST_MOUNT_PATH = argv[i];
            break;
        }
    }

    //  Mount the provided host path as the System mount location
    hostRootPath = nnsdkSetupHostSystemFs(MOUNT_POINT, HOST_MOUNT_PATH, 1);
    EXPECT_TRUE(NULL != ::hostRootPath);
*/
    const int exitCode = RUN_ALL_TESTS();
    nnt::Exit(exitCode);
}

extern "C" void nninitStartup()
{
    const size_t MemoryHeapSize = 24 * 1024 * 1024;
    auto result = nn::os::SetMemoryHeapSize( MemoryHeapSize );

    NN_ASSERT( result.IsSuccess() );

    // メモリヒープから malloc で使用するメモリ領域を確保
    uintptr_t address = 0;

    result = nn::os::AllocateMemoryBlock( &address, MemoryHeapSize );
    NN_ASSERT( result.IsSuccess() );

    // malloc 用のメモリ領域を設定する
    nn::init::InitializeAllocator( reinterpret_cast<void*>(address), MemoryHeapSize );

    NN_LOG("nninitStartup: loaded at %p\n", (void *)nninitStartup);
}
